/*
    LIBSNSP - A C Library for the Simple Network Scanning Protocol
    Copyright (C) 2001 Michael R. Kllejan 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: report.h,v 1.2 2001/10/03 22:41:18 michael Exp $ */

#ifndef REPORT_H
#define REPORT_H 1

#include <libxml/tree.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

#include "linkedlist.h"
#include "cmdport.h"

typedef struct snsp_report snsp_report_t;
typedef struct snsp_report_host	snsp_report_host_t;
typedef struct snsp_report_port	snsp_report_port_t;

struct snsp_report {
	LINKED_LIST_T(snsp_report_host_t*)	*hosts;
};

struct snsp_report_host {
	char	  			                      *address;
	char  				                      *scantype;
	LINKED_LIST_T(snsp_report_port_t*)	*ports;
};

typedef enum {
	snsp_report_port_status_open = 0,
	snsp_report_port_status_closed,
	snsp_report_port_status_notscanned,
  snsp_report_port_status_filtered
} snsp_report_port_status_t;

struct snsp_report_port {
	snsp_report_port_status_t	             status;
	LINKED_LIST_T(snsp_portrange_t*)       *portlist;
};

snsp_report_t* snsp_report_alloc ();
void snsp_report_free ( snsp_report_t **report );
snsp_report_port_t* snsp_report_port_alloc ();
void snsp_report_port_free ( snsp_report_port_t **port );
snsp_report_host_t* snsp_report_host_alloc ();
void snsp_report_host_free ( snsp_report_host_t **host );
char* snsp_report_render ( snsp_report_t *report );
void* snsp_report_shrink ( snsp_report_t *report );
snsp_report_t* snsp_report_parse ( char* );
#endif /* REPORT_H */
