#!/usr/bin/ruby1.8
require 'SVM'
include SVM
puts "TEST of the Ruby libsvm bindings"
puts "------------------------------------"
pa = Parameter.new
pa.C = 100
pa.svm_type = NU_SVC
pa.degree = 1
pa.coef0 = 0
pa.eps= 0.001
s = Marshal.dump(pa)
lpa = Marshal.load(s)
sp = Problem.new
labels = [0, 1, 1, 0]
samples = [[0,0], [0,1], [1,0], [1,1]]
labels.each_index { |i| sp.addExample(labels[i], samples[i]) }
kernels = [ LINEAR, POLY, RBF, SIGMOID ]
knames = [ 'LINEAR ', 'POLY   ', 'RBF    ', 'SIGMOID' ]
kernels.each_index { |j|
  pa.kernel_type = kernels[j]
  m = Model.new(sp, pa)
  ec = 0
  labels.each_index { |i|
    pred, probs = m.predict_probability(samples[i])
    puts "Got #{pred} and #{probs.join(',')} for sample: [#{samples[i].join(',')}]  Label: #{labels[i]}  Pred: #{pred} Kernel: #{knames[j]} sv: #{m.svcount}"
    ec += 1 if labels[i] != pred
  }
  puts "Kernel #{knames[j]} made #{ec} errors"
}

