#ifndef TAGCOLL_CHANGES_H
#define TAGCOLL_CHANGES_H

/*
 * Represent a list of tag substitutions to apply as a TagcollFilter
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <tagcoll/TagcollConsumer.h>
#include <tagcoll/TagcollFilter.h>

#include <map>
#include <string>

namespace Tagcoll
{

// List of changes to apply to tag names with a tagged collection is being
// parsed
class ChangeList : public TagcollConsumer<std::string>
{
protected:
	typedef std::map<std::string, std::string> changes_t;
	changes_t changes;
	
public:
	virtual ~ChangeList() throw () {}

	virtual void consume(const std::string& item) throw () {}
	virtual void consume(const std::string& item, const OpSet<std::string>& tags) throw ();
	
	// Change a single tag
	std::string change(const std::string& tag) const throw ();

	// Change all the tags in a tag set
	OpSet<std::string> change(const OpSet<std::string>& tags) const throw ();
};

class ApplyChanges : public TagcollFilter<std::string>
{
protected:
	ChangeList& changes;
	
public:
	ApplyChanges(ChangeList& changes) throw ()
		: changes(changes) {}

	virtual void consume(const std::string& item) throw ()
	{
		consumer->consume(changes.change(item));
	}

	virtual void consume(const std::string& item, const OpSet<std::string>& tags) throw ()
	{
		consumer->consume(item, changes.change(tags));
	}
};

};

// vim:set ts=4 sw=4:
#endif
