/*  tiffep - TI File Format Engine and Proxy
 *  Copyright (C) 2000-2001  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_H__
#define __TIFFEP_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include "str.h"
#include <stdlib.h>
#ifndef __WIN32__
# include <unistd.h>
#else
# include <io.h>
#endif
#include <glib.h>

#include "intl.h"    // i18n support

#include "export.h"  // symbol export macros
#include "macros.h"  // useful macros
#include "verbose.h" // DISPLAY function support

#include "tiffep_ver.h" // TiFFEP version number
#include "tiffep_paths.h"   // some file paths

#include "types.h"     // some type definitions
#include "com_defs.h"  // Unix/Win32 common type definitions
#include "errcodes.h"  // error codes & messages
#include "tiffep_err.h"     // error function
#include "perror.h"    // Win32 only
#include "shm.h"       // Shared Memory support (Linux/Win32)
#include "sock.h"      // Socket support (Linux/Win32)
#include "commands.h"   // command defs & functions
#include "messages.h"
#include "reg_file.h"  // registry functions
#include "ti_files.h"  // structure & functions for handling TI file
#include "ti_folders.h"// structure & functions for handling TI folders
#include "ti_vars.h"   // structure & functions for handling TI variables
#include "interface.h" // the interface of the library
#include "misc_fncts.h"      // some miscellaneous functions
#include "calc_defs.h"

#endif
