/*! \file BinningObject.h
    \brief Definition of the Template class BinningObject.
    
    Magics Team - ECMWF 2011
    
    Started: Thu 7-Apr-2011
    
    Changes:
    
*/

#ifndef BinningObject_H
#define BinningObject_H

#include "magics.h"
#include "Matrix.h"
#include "BinningObjectAttributes.h"
#include "BasePointsHandler.h"
#include "IntervalMap.h"
#include "Factory.h"
#include "MagTranslator.h"

namespace magics {

  
class BinningObject: public BinningObjectAttributes {

public:
	BinningObject();
	~BinningObject();

	virtual BinningObject* clone() const { return new BinningObject(); }
  template <class P>
	Matrix* operator()(PointsList<P>& points)
	{

		Matrix* matrix = new Matrix();

			double minx = points.minX();
			double maxx = points.maxX();
			double miny = points.minY();
			double maxy = points.maxY();
			double max = points.min();
			double min = points.max();

		IntervalMap<int> xbinns;
		IntervalMap<int> ybinns;

		map<string, binner>::iterator binner = binners_x_.find(x_);

		if ( binner != binners_x_.end() ) {
		   	 (this->*binner->second)(matrix->columnsAxis(), minx, maxx);
		   	 if ( matrix->columnsAxis().empty() ) {
		   		MagLog::warning() << " could not find any binns: return to count method" << endl;
		   		countx(matrix->columnsAxis(), minx, maxx);
		   	 }
		}
		else {
			MagLog::warning() << " could not find the method " << x_ << " for binning: return to count method" << endl;
			countx(matrix->columnsAxis(), minx, maxx);
		}
		build(matrix->columnsAxis(), xbinns);
		binner = binners_y_.find(y_);

		if ( binner != binners_y_.end() ) {
			(this->*binner->second)(matrix->rowsAxis(), miny, maxy);
			 if ( matrix->rowsAxis().empty() ) {
				   		MagLog::warning() << " could not find any binns: return to count method" << endl;
				   		county(matrix->columnsAxis(), minx, maxx);
				   	 }
		}
		else {
			MagLog::warning() << " could not find the method " << y_ << " for binning: return to count method" << endl;
			county(matrix->rowsAxis(), miny, maxy);
		}
		build(matrix->rowsAxis(), ybinns);


		matrix->setMapsAxis();
//		double val = 0;
		vector<double> total;

		for ( int j = 0; j < matrix->columns(); j++)
			for ( int i = 0; i <  matrix->rows(); i++) {
				matrix->push_back(0);
				total.push_back(0);
			}

		double columns = matrix->columns();
		points.setToFirst();
		while ( points.more() ) {
			const P& point = points.current();
			int x = xbinns.find(point.x_, -1);
			int y = ybinns.find(point.y_, -1);
			if ( x!= -1 && x!=-1) {
				(*matrix)[ y * columns + x] = (*matrix)[ y * columns + x]+1;
				total[ y * columns + x] = total[y * columns + x]+point.value();
			}
			points.advance();
		}

		if ( min != max ) {
			for (unsigned int i = 0; i < matrix->size(); ++i) {

				if ( (*matrix)[i] != 0 )
					(*matrix)[i] = total[i]/(*matrix)[i];
			}
		}
		return matrix;
	}


protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 void print(ostream&) const;
	 typedef void (BinningObject::*binner)(vector<double>&, double, double);
	 		 map<string,  binner> binners_x_;
	 		 map<string,  binner> binners_y_;

	 	void build(vector<double>& vals, IntervalMap<int>& binns);
	 	 void countx(vector<double>&, double, double);
	 	 void listx(vector<double>&, double, double);
	 	 void intervalx(vector<double>&, double, double);

	 	 void county(vector<double>&, double, double);
	 	 void listy(vector<double>&, double, double);
	 	 void intervaly(vector<double>&, double, double);
private:
    //! Copy constructor - No copy allowed
	BinningObject(const BinningObject&);
    //! Overloaded << operator to copy - No copy allowed
	BinningObject& operator=(const BinningObject&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const BinningObject& p)
		{ p.print(s); return s; }

};


class NoBinningObject: public BinningObject {

public:
	NoBinningObject() {}
	~NoBinningObject() {}
	BinningObject* clone() const { return new NoBinningObject(); }
};


template <>
class MagTranslator<string, BinningObject> {
public:
	BinningObject* operator()(const string& val )
	{
		return SimpleObjectMaker<BinningObject>::create(val);
	}

	BinningObject* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}
};
} // namespace magics
#endif
