/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IsoLabelAttributes.h
    \brief Definition of IsoLabel Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:43 2012
*/
   

#ifndef IsoLabelAttributes_H
#define IsoLabelAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class IsoLabelAttributes 
{
public:
//  --  constructor
    IsoLabelAttributes();
    
//  --  destructor
    virtual ~IsoLabelAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const IsoLabelAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Type of label (TEXT/NUMBER/BOTH) 
    \param type Setting contour_label_type - default=number
*/
	void setType(const string& type) 
		{ type_ =  type; } 
	const string& getType() const 
		{ return type_; } 
        
/*!
    Magics Information:
    \brief  Text for labels 
    \param text Setting contour_label_text - default=
*/
	void setText(const string& text) 
		{ text_ =  text; } 
	const string& getText() const 
		{ return text_; } 
        
/*!
    Magics Information:
    \brief  Height of contour labels 
    \param height Setting contour_label_height - default=0.3
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Format of contour labels (MAGICS Format/(AUTOMATIC)) 
    \param format Setting contour_label_format - default=(automatic)
*/
	void setFormat(const string& format) 
		{ format_ =  format; } 
	const string& getFormat() const 
		{ return format_; } 
        
/*!
    Magics Information:
    \brief Label Blanking
    \param blanking Setting contour_label_blanking - default=on
*/
	void setBlanking(bool blanking) 
		{ blanking_ =  blanking; } 
	bool getBlanking() const 
		{ return blanking_; } 
        
/*!
    Magics Information:
    \brief  Name of the font  
    \param font Setting contour_label_font - default=sansserif
*/
	void setFont(const string& font) 
		{ font_ =  font; } 
	const string& getFont() const 
		{ return font_; } 
        
/*!
    Magics Information:
    \brief Style of the font bold/italic
    \param style Setting contour_label_font_style - default=normal
*/
	void setStyle(const string& style) 
		{ style_ =  style; } 
	const string& getStyle() const 
		{ return style_; } 
        
/*!
    Magics Information:
    \brief  Colour of contour labels 
    \param colour Setting contour_label_colour - default=contour_line_colour
*/
	void setColour(const string& colour) 
		{ colour_ =  colour; } 
	const string& getColour() const 
		{ return colour_; } 
        
/*!
    Magics Information:
    \brief  Every Nth contour line is labelled 
    \param frequency Setting contour_label_frequency - default=2
*/
	void setFrequency(int frequency) 
		{ frequency_ =  frequency; } 
	int getFrequency() const 
		{ return frequency_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string type_;
	string text_;
	double height_;
	string format_;
	bool blanking_;
	string font_;
	string style_;
	string colour_;
	int frequency_;

private:
  
	friend ostream& operator<<(ostream& s,const IsoLabelAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
