/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file SymbolTableModeAttributes.h
    \brief Definition of SymbolTableMode Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:44 2012
*/
   

#ifndef SymbolTableModeAttributes_H
#define SymbolTableModeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class SymbolTableModeAttributes 
{
public:
//  --  constructor
    SymbolTableModeAttributes();
    
//  --  destructor
    virtual ~SymbolTableModeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const SymbolTableModeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Table of minimum values. This table should be passed to MAGICS when SYMBOL_TABLE_MODE is set to ON. The table is used in conjunction with SYMBOL_MAX_TABLE  
    \param min Setting symbol_min_table - default=floatarray()
*/
	void setMin(floatarray min) 
		{ min_ =  min; } 
	floatarray getMin() const 
		{ return min_; } 
        
/*!
    Magics Information:
    \brief  Table of maximum values. This table should be passed to MAGICS when SYMBOL_TABLE_MODE is set to ON. The table is used in conjunction with SYMBOL_MIN_TABLE  
    \param max Setting symbol_max_table - default=floatarray()
*/
	void setMax(floatarray max) 
		{ max_ =  max; } 
	floatarray getMax() const 
		{ return max_; } 
        
/*!
    Magics Information:
    \brief  Table of MARKER indices. This table may be used when TABLE_MODE is ON. The table is to be used in conjunction with SYMBOL_MIN_TABLE and SYMBOL_MAX_TABLE  
    \param marker Setting symbol_marker_table - default=intarray()
*/
	void setMarker(intarray marker) 
		{ marker_ =  marker; } 
	intarray getMarker() const 
		{ return marker_; } 
        
/*!
    Magics Information:
    \brief  Table of Symbol names. This table may be used when TABLE_MODE is ON. The table is to be used in conjunction with SYMBOL_MIN_TABLE and SYMBOL_MAX_TABLE  
    \param symbol Setting symbol_name_table - default=stringarray()
*/
	void setSymbol(stringarray symbol) 
		{ symbol_ =  symbol; } 
	stringarray getSymbol() const 
		{ return symbol_; } 
        
/*!
    Magics Information:
    \brief  Table of SYMBOL colours. This table may be used when TABLE_MODE is ON. The table is to be used in conjunction with SYMBOL_MIN_TABLE and SYMBOL_MAX_TABLE  
    \param colour Setting symbol_colour_table - default=stringarray()
*/
	void setColour(stringarray colour) 
		{ colour_ =  colour; } 
	stringarray getColour() const 
		{ return colour_; } 
        
/*!
    Magics Information:
    \brief  Table of SYMBOL heights. This table may be used when TABLE_MODE is ON. The table is to be used in conjunction with SYMBOL_MIN_TABLE and SYMBOL_MAX_TABLE  
    \param height Setting symbol_height_table - default=floatarray()
*/
	void setHeight(floatarray height) 
		{ height_ =  height; } 
	floatarray getHeight() const 
		{ return height_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	floatarray min_;
	floatarray max_;
	intarray marker_;
	stringarray symbol_;
	stringarray colour_;
	floatarray height_;

private:
  
	friend ostream& operator<<(ostream& s,const SymbolTableModeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
