/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This module handles the conversion of KSC5601 hangul characters and 
 * romanised Hangul to internal format (and back). */

/* Variables. ===============================================================*/

extern bool_t convert_to_ksc; 
/* Indicates whether Hangul output is converted to KSC5601
 * (else output is converted to romanised Hangul). */

/* Functions. ===============================================================*/

extern void init_hangul( void );
/* Initialise hangul conversions. */

extern void terminate_hangul( void );
/* Free memory used by hangul conversions. */

extern void decode_hangul( string_t *string_p );
/* Decode *STRING_P to external format.
 * *STRING_P must be a string on the heap; 
 * it will be replaced by the new string which is also on the heap. */

extern void encode_hangul( string_t *string_p );
/* Encode *STRING_P to internal format.
 * *STRING_P must be a string on the heap; 
 * it will be replaced by the new string which is also on the heap. */

/* End of file. =============================================================*/
