/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This module defines a translation table from KSC code to trigem code. */

/* Constants ----------------------------------------------------------------*/

enum {FIRST_LETTER = 0xa4a1, LAST_LETTER = 0xa4d3};
enum {LETTER_COUNT = LAST_LETTER - FIRST_LETTER + 1};

enum {LOBYTE_FIRST = 0xa1, LOBYTE_LAST = 0xfe};
enum {HIBYTE_FIRST = 0xb0, HIBYTE_LAST = 0xc8};
enum {KSC_PAGE_SIZE = LOBYTE_LAST - LOBYTE_FIRST + 1};
enum {KSC_PAGE_COUNT = HIBYTE_LAST - HIBYTE_FIRST + 1};
enum {SYLLABLE_COUNT = KSC_PAGE_SIZE * KSC_PAGE_COUNT};

enum {KSC_TABLE_SIZE = LETTER_COUNT + SYLLABLE_COUNT};
/* Total number of KSC codes. */

extern u_short_t ksc_table[ KSC_TABLE_SIZE ];
/* ksc_table[ ksc_to_table_index( KSC ) ] is the trigem code of KSC. */

/* Conversion functions. ----------------------------------------------------*/

extern int_t ksc_to_table_index( int_t ksc );
/* Convert the KSC5601 code KSC to the corresponding index of KSC_TABLE. */

extern int_t table_index_to_ksc( int_t index );
/* Convert the INDEX into KSC_TABLE into the corresponding KSC5601 code. */

/* End of file. -------------------------------------------------------------*/
