/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "mas/mas.h"
#include "mas/mas_core.h"


#define M_IMAGE "/usr/local/mas/share/pixmaps/M_80px_icon.png"



GtkWidget *hscale;
mas_device_t func;
mas_device_t sbuf;
char active_function[32];



void do_mas_set( char *function_name )
{
    struct mas_package pkg;
    char pbuf[256];

    masc_setup_package( &pkg, pbuf, sizeof pbuf, MASC_PACKAGE_STATIC );
    masc_pushk_string( &pkg, "function", function_name );
    masc_finalize_package( &pkg );
    
    mas_set( func, "function", &pkg );
    masc_strike_package( &pkg );
}


gint
cb_delete_event(GtkWidget *w, GdkEvent *e, gpointer o)
{
/*     gtk_widget_hide_all( GTK_WIDGET(o) );  */
    
    gtk_main_quit();
    return TRUE;
}


gint cb_radio_toggled( GtkWidget *w, gpointer data )
{
    static const int n_functions = 6;
    static const char *function_names[] =
        {    "sine wave",
             "triangle wave",
             "square wave",
             "sawtooth wave",
             "white noise",
             "pink noise" 
        };

    int i;
    char *a;
    
    a = g_object_get_data( G_OBJECT(w), "function" );

    for( i=0; i<n_functions; i++ )
    {
        if( !strcmp(a, function_names[i]) )
        {
            if( !strcmp(a, active_function) )
                return TRUE;
            strcpy( active_function, function_names[i] );

/*             mas_source_stop( sbuf ); */
            do_mas_set( active_function );
/*             mas_source_play( sbuf ); */
            
            
            if( !strcmp( active_function, "white noise" ) || !strcmp( active_function, "pink noise" ) )
                gtk_widget_set_sensitive( hscale, FALSE );
            else
                gtk_widget_set_sensitive( hscale, TRUE );
            
            return TRUE;
        }
    }
    
    
    return TRUE;
}


void cb_change_freq (GtkAdjustment *adj)
{
    mas_func_set_frequency( func, adj->value );
}

/* convenience functions */

GtkWidget *make_menu_item (gchar *name, GtkSignalFunc callback,
                           gpointer data)
{
  GtkWidget *item;
  
  item = gtk_menu_item_new_with_label (name);
  gtk_signal_connect (GTK_OBJECT (item), "activate",
                      callback, data);
  gtk_widget_show (item);

  return item;
}

void scale_set_default_values (GtkScale *scale)
{
  gtk_range_set_update_policy (GTK_RANGE (scale),
                               GTK_UPDATE_CONTINUOUS);
  gtk_scale_set_digits (scale, 1);
  gtk_scale_set_value_pos (scale, GTK_POS_TOP);
  gtk_scale_set_draw_value (scale, TRUE);
}

/* makes the sample window */

void create_range_controls (void)
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *frame_box;
  GtkWidget *outer_frame_box;
  GtkWidget *box1, *box2;
  GtkWidget *button;
  GtkWidget *button2;
  GtkWidget *image;
  GtkWidget *separator;
  GtkWidget *freqadj;
  GtkObject *adj1;
  char *title;
  
  /* standard window-creating stuff */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC(cb_delete_event),
                      (gpointer)window);
  
  title = masc_construct_title( "MAS Signal Generator");
  if( title )
  {
      gtk_window_set_title ( GTK_WINDOW (window), title );
      masc_rtfree( title );
  }
  else
  {
      gtk_window_set_title ( GTK_WINDOW (window), "MAS Signal Generator" );
  }
  
  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box1);


  box2 = gtk_hbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);


  /* value, lower, upper, step_increment, page_increment, page_size */
  /* note that the page_size value only makes a difference for
     scrollbar widgets, and the highest value you'll get is actually
     (upper - page_size). */
  adj1 = gtk_adjustment_new (440.0, 35.0, 8001.0, 0.1, 1.0, 1.0);
  
  /* reuse the same adjustment */
  hscale = gtk_hscale_new (GTK_ADJUSTMENT (adj1));
  gtk_widget_set_usize (GTK_WIDGET (hscale), 200, 30);
  scale_set_default_values (GTK_SCALE (hscale));
  gtk_signal_connect (GTK_OBJECT (adj1), "value_changed", GTK_SIGNAL_FUNC
                      (cb_change_freq), NULL);
  gtk_box_pack_start (GTK_BOX (box2), hscale, TRUE, TRUE, 0);


  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);


  
  frame = gtk_frame_new( "function" );

  outer_frame_box = gtk_hbox_new( FALSE, 0 );
  
  frame_box = gtk_vbox_new( FALSE, 0 );
  gtk_container_set_border_width( GTK_CONTAINER(frame_box), 6 );
  
  button = gtk_radio_button_new_with_label( NULL, "sine wave" );
  g_object_set_data( G_OBJECT(button), "function", 
                     (gpointer)("sine wave") );
  gtk_signal_connect( GTK_OBJECT(button), "toggled",
                      GTK_SIGNAL_FUNC(cb_radio_toggled),
                      (gpointer) 0 );
  gtk_box_pack_start( GTK_BOX(frame_box), button, TRUE, TRUE, 0 );

  
  button2 = gtk_radio_button_new_with_label_from_widget(
      GTK_RADIO_BUTTON(button),"triangle wave" );
  g_object_set_data( G_OBJECT(button2), "function", 
                     (gpointer)("triangle wave") );
  gtk_signal_connect( GTK_OBJECT(button2), "toggled",
                      GTK_SIGNAL_FUNC(cb_radio_toggled),
                      (gpointer) 0 );

  gtk_box_pack_start( GTK_BOX(frame_box), button2, TRUE, TRUE, 0 );

  
  button2 = gtk_radio_button_new_with_label_from_widget(
      GTK_RADIO_BUTTON(button), "square wave" );
  g_object_set_data( G_OBJECT(button2), "function", 
                     (gpointer)("square wave") );
  gtk_signal_connect( GTK_OBJECT(button2), "toggled",
                      GTK_SIGNAL_FUNC(cb_radio_toggled),
                      (gpointer) 0 );
  gtk_box_pack_start( GTK_BOX(frame_box), button2, TRUE, TRUE, 0 );

  
  button2 = gtk_radio_button_new_with_label_from_widget(
      GTK_RADIO_BUTTON(button), "sawtooth wave" );
  g_object_set_data( G_OBJECT(button2), "function", 
                     (gpointer)("sawtooth wave") );
  gtk_signal_connect( GTK_OBJECT(button2), "toggled",
                      GTK_SIGNAL_FUNC(cb_radio_toggled),
                      (gpointer) 0 );
  gtk_box_pack_start( GTK_BOX(frame_box), button2, TRUE, TRUE, 0 );

  
  button2 = gtk_radio_button_new_with_label_from_widget(
      GTK_RADIO_BUTTON(button), "white noise" );
  g_object_set_data( G_OBJECT(button2), "function", 
                     (gpointer)("white noise") );
  gtk_signal_connect( GTK_OBJECT(button2), "toggled",
                      GTK_SIGNAL_FUNC(cb_radio_toggled),
                      (gpointer) 0 );
  gtk_box_pack_start( GTK_BOX(frame_box), button2, TRUE, TRUE, 0 );

  button2 = gtk_radio_button_new_with_label_from_widget(
      GTK_RADIO_BUTTON(button), "pink noise" );
  g_object_set_data( G_OBJECT(button2), "function", 
                     (gpointer)("pink noise") );
  gtk_signal_connect( GTK_OBJECT(button2), "toggled",
                      GTK_SIGNAL_FUNC(cb_radio_toggled),
                      (gpointer) 0 );
  gtk_box_pack_start( GTK_BOX(frame_box), button2, TRUE, TRUE, 0 );

  gtk_box_pack_start (GTK_BOX (outer_frame_box), frame_box, FALSE, TRUE, 0);

  image = gtk_image_new_from_file( M_IMAGE );

  gtk_box_pack_start( GTK_BOX( outer_frame_box ), image, TRUE, TRUE, 0);


  
  gtk_box_pack_start (GTK_BOX (box1), outer_frame_box, FALSE, TRUE, 0);
  
/*   separator = gtk_hseparator_new (); */
/*   gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0); */


  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);


  button = gtk_button_new_with_label ("Quit");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                             GTK_SIGNAL_FUNC(cb_delete_event),
                             (gpointer)window);
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
/*   GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); */
/*   gtk_widget_grab_default (button); */


  gtk_widget_show_all(window);
}

int main(int argc, char* argv[])
{
    mas_port_t    func_source, mix_sink;
/*     mas_device_t  hexprint; */
/*     mas_port_t    hexprint_sink; */
    
    mas_port_t  sbuf_sink, sbuf_source;
#ifdef USE_VISUAL
    mas_port_t    visual_sink, visual_source;
    mas_device_t  visual;
#endif
    struct mas_data_characteristic* dc;
    int32 err;

    if (argc != 1)
    {
	fprintf(stderr, "usage:    signal \n");
	exit(0);
    }

    strcpy( active_function, "sine wave" );
    
    printf("Connecting to MAS.\n");
    err = mas_init();
    gtk_init(&argc, &argv);

    if (err < 0)
    {
	masc_logerror(err, "connection with server failed.");
	exit(1);
    }    

    

/*     mas_asm_instantiate_device( "hexprint", 0, 0, &hexprint); */
/*     mas_asm_get_port_by_name( hexprint, "hexprint_sink", &hexprint_sink ); */
    
    err = mas_asm_get_port_by_name( 0, "default_mix_sink", &mix_sink );

    masc_log_message( 0, "Instantiating function generator device.");
    err = mas_asm_instantiate_device( "func", 0, 0, &func );
    if ( err < 0 ) 
    {
        masc_logerror(err, "Failed to instantiate endian converter device");
        exit(1);
    }
    err = mas_asm_get_port_by_name( func, "func_source", &func_source );

#ifdef USE_VISUAL
    err = mas_asm_instantiate_device( "visual", 0, 0, &visual );
    if ( err < 0 )
    {
        masc_logerror(err, "Failed to instantiate visualization device");
        exit(1);
    }
    err = mas_asm_get_port_by_name( visual, "source", &visual_source );
    err = mas_asm_get_port_by_name( visual, "sink", &visual_sink );
#endif

    dc = MAS_NEW( dc );
    masc_setup_dc( dc, 6 );
    masc_append_dc_key_value( dc, "format", "linear" );
    masc_append_dc_key_value( dc, "resolution", "16" );
    masc_append_dc_key_value( dc, "sampling rate", "44100" );
    masc_append_dc_key_value( dc, "channels", "2" );
    masc_append_dc_key_value( dc, "endian", "host" );

    err = mas_asm_instantiate_device( "sbuf", 0, 0, &sbuf );
    if ( err < 0 ) 
    {
        masc_logerror(err, "Failed to instantiate sbuf device");
        exit(1);
    }
    err = mas_asm_get_port_by_name( sbuf, "source", &sbuf_source );
    err = mas_asm_get_port_by_name( sbuf, "sink", &sbuf_sink );

    
    err = mas_asm_connect_source_sink( func_source, sbuf_sink, dc );
    if ( err < 0 ) 
    {
        masc_logerror(err, "Failed to connect func to sbuf ");
        exit(1);
    }

    
#ifndef USE_VISUAL
    err = mas_asm_connect_source_sink( sbuf_source, mix_sink, dc );
    if ( err < 0 ) 
    {
        masc_logerror(err, "Failed to connect sbuf to mix ");
        exit(1);
    }
#endif
#ifdef USE_VISUAL
    err = mas_asm_connect_source_sink( sbuf_source, visual_sink, dc );
    if ( err < 0 ) 
    {
        masc_logerror(err, "Failed to connect sbuf to visual ");
        exit(1);
    }
    
    {
        /* get the visual device to display itself */
        struct mas_package pkg;
        
        masc_setup_package( &pkg, NULL, 0, 0 );
        masc_pushk_int16( &pkg, "do_work", 1 );
        masc_finalize_package( &pkg );
        mas_set( visual, "do_work", &pkg );
        masc_strike_package( &pkg );
    }    
    
    err = mas_asm_connect_source_sink( visual_source, mix_sink, dc );
    if ( err < 0 )
    {
        masc_logerror(err, "Failed to connect visual to mixer");
        exit(1);
    }
#endif
    
    mas_func_set_frequency( func, 440 );
    
    create_range_controls();

    mas_source_play( func );
    mas_source_play( sbuf );
    
    gtk_main();

    mas_source_stop( func );
    mas_source_stop( sbuf );

    sleep( 1 );
    
    return 0;
}
