""" Utility functions.

fixme: I don't like random collections of utility functions! Where should
this go?

"""


# Standard library imports.
import os, sys
from traceback import format_list, extract_tb
from zipfile import is_zipfile, ZipFile

# Enthought library imports.
from enthought.io.api import File


def get_module_name(filename):
    """ Get the fully qualified module name for a filename.

    For example, if the filename is
        
    /enthought/envisage/core/core_plugin_definition.py 

    this method would return 

    enthought.envisage.core.core_plugin_definition
        
    """

    if os.path.exists(filename):
        # Get the name of the module minus the '.py'
        module, ext = os.path.splitext(os.path.basename(filename))

        # Start with the actual module name.
        module_path = [module]

        # If the directory is a Python package then add it to the module path.
        parent = File(os.path.dirname(filename))
        while parent.is_package:
            module_path.insert(0, parent.name)
            parent = parent.parent

        module_name = '.'.join(module_path)

    # If the file does not exist then it might be a zip file path.
    else:
        module_name = get_module_name_from_zip(filename)

    return module_name

# fixme: WIP
def get_module_name_from_zip(filename):

    # first, find the zip file in the path
    filepath = filename
    zippath = None

    while filepath != '' and not is_zipfile(filepath) and \
              os.path.splitdrive(filepath)[1] != '\\' \
              and os.path.splitdrive(filepath)[1] != '/':
        filepath, tail = os.path.split(filepath)
        if zippath is not None:
            zippath = tail + '/' + zippath 
        else:
            zippath = tail
            
    if not is_zipfile(filepath):
        return None

    # if the split left a preceding slash on the zippath then remove
    # it
    if zippath.startswith('\\') or zippath.startswith('/'):
        zippath = zippath[1:]

    # replace any backwards slashes with forward slashes
    zippath = zippath.replace('\\', '/')

    # Get the name of the module minus the '.py'
    module, ext = os.path.splitext(os.path.basename(zippath))

    # Start with the actual module name.
    module_path = [module]

    # to get the module name, we walk through the zippath until we
    # find a parent directory that does NOT have a __init__.py file
    z = ZipFile(filepath)

    parentpath = os.path.dirname(zippath)
    while path_exists_in_zip(z, parentpath + '/__init__.py'):
        module_path.insert(0, os.path.basename(parentpath))
        parentpath = os.path.dirname(parentpath)

    z.close()
            
    return '.'.join(module_path)

# fixme: WIP        
def path_exists_in_zip(zfile, path):

    try:
        zfile.getinfo(path)
        exists = True
    except:
        exists = False

    return exists

# fixme: WIP
def is_zip_path(path):
    """ Returns True if the path refers to a zip file. """

    filepath = path
    while not is_zipfile(filepath) and \
              os.path.splitdrive(filepath)[1] != '\\' \
              and os.path.splitdrive(filepath)[1] != '/':
        filepath = os.path.dirname(filepath)

    return is_zipfile(filepath)

# fixme: WIP
def get_zip_path(filename):
    """ Returns the path to the zip file contained in the filename.

    fixme: An example here would help.

    """

    filepath = filename
    zippath = None
    while not is_zipfile(filepath) and \
              os.path.splitdrive(filepath)[1] != '\\' \
              and os.path.splitdrive(filepath)[1] != '/':
        filepath, tail = os.path.split(filepath)
        if zippath is not None:
            zippath = tail + '/' + zippath 
        else:
            zippath = tail

    return zippath

def get_traceback_message():
    type, value, tb = sys.exc_info()
    return ' '.join(format_list(extract_tb(tb)))

#### EOF ######################################################################
