""" Tests a simple plugin. """


# Standard library imports.
import os, shutil, sys, time, unittest

# Enthought library imports.
from enthought.io import File
from enthought.envisage.project import Project, Workspace
from enthought.envisage.project.simple_project import create_project
from enthought.naming.api import NameNotFoundError


class SimpleProjectTestCase(unittest.TestCase):
    """ Tests a simple project. """

    ###########################################################################
    # 'TestCase' interface.
    ###########################################################################

    def setUp(self):
        """ Prepares the test fixture before each test method is called. """

        try:
            shutil.rmtree('Workspace')

        except:
            pass
        
        os.mkdir('Workspace')
        
        self.workspace = Workspace(path='Workspace')
        try:
            self.project = self.workspace.lookup('My Project')

        except NameNotFoundError:
            self.project = create_project('My Project', self.workspace)
        
        return

    def tearDown(self):
        """ Called immediately after each test method has been called. """

        shutil.rmtree('Workspace')
        
        return

    ###########################################################################
    # Tests.
    ###########################################################################
    
    def test_lookup(self):
        """ lookup objects in the project """

        # Convenience.
        project = self.project

        # Lookup a non-existent name.
        self.failUnlessRaises(NameNotFoundError, project.lookup, 'foo')
        
        # Lookup a Python script.
        script = project.lookup('scripts/foo.py')
        self.assert_(script is not None)
        self.assert_(type(script) is File)
    
        # Save the project.
        project.save()

        return
    
#### EOF ######################################################################
