/* -*- C -*- 
   mboxgrep - scan mailbox for messages matching a regular expression
   Copyright (C) 2000, 2001, 2002  Daniel Spiljar
   
   Mboxgrep is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   Mboxgrep is distributed in the hope that it will be useful, but 
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with mboxgrep; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
   $Id: mbox.h,v 1.4 2002/01/19 20:30:06 dspiljar Exp $ */

#ifndef MBOX_H
#define MBOX_H 1

#include <config.h>

#include <stdio.h>		/* for FILE structure */
#ifdef HAVE_LIBZ
#include <zlib.h>               /* for gzFile structure */
#endif /* HAVE_LIBZ */

#include "mboxgrep.h"           /* for message_t structure */

/* open a mbox folder and lock it */
FILE *mbox_open (const char *path, const char *mode);
/* open a temporary file for writing */
FILE *tmpfile_open(void);
/* unlock the mbox folder and close it */
void mbox_close (FILE * fp);
/* read a message from a mbox folder */
message_t *mbox_read_message (FILE * fp);

#ifdef HAVE_LIBZ

/* open a compressed mbox folder and lock it */
gzFile *gzmbox_open (const char *path, const char *mode);

gzFile *gztmpfile_open (void);

/* read a message from a compressed mbox folder */
message_t *gzmbox_read_message (gzFile * fp);
/* unlock the compressed mbox folder and close it */
void gzmbox_close (gzFile * fp);

#endif /* HAVE_LIBZ */

#endif /* MBOX_H */
