#ifndef __SCHEDULED_RECORDING_H__
#define __SCHEDULED_RECORDING_H__

#include "epg.hh"
#include "xml.hh"

#define RECORDING_TYPE_NONE				0
#define RECORDING_TYPE_ONCE_OFF			1
#define RECORDING_TYPE_EVERY_DAY_NOT_WE	2
#define RECORDING_TYPE_EVERY_DAY_WE		3
#define RECORDING_TYPE_EVERY_WEEK		4

#define SECONDS_IN_HOUR		(60*60)
#define SECONDS_IN_DAY		(SECONDS_IN_HOUR*24)
#define SECONDS_IN_WEEK		(SECONDS_IN_DAY*7)

class ScheduledRecording
{
private:
	String get_day_of_week_text();

public:
	ScheduledRecording();	
	ScheduledRecording(xmlNodePtr n);
	void load(xmlNodePtr n);
	
	String channel_name;
	String description;
	guint type;
	time_t start_time;
	guint duration;
	xmlNodePtr node;

	gboolean is_current();
	String get_start_time_text();
	String get_duration_text();
	String get_type_text();
	time_t get_local_start_time() const;
};

#endif
