/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __XML_H__
#define __XML_H__

#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>
#include <libxml/xmlsave.h>
#include "scope_log.hh"
#include "string_utility.hh"
#include "integer.hh"
#include "exception.hh"

class XmlNode
{
private:
	xmlNodePtr node;
	void create_node(xmlNodePtr n);
	
public:
	XmlNode(const XmlNode& n);
	XmlNode(xmlNodePtr node);
	
	xmlNodePtr create_child_node(const String& name);
	XmlNode& operator=(xmlNodePtr n);

	String get_attribute_value(const String& name) const;
	int get_int_attribute_value(const String& name) const;
	
	void set_content(const String& content, gboolean encode = true);
	void set_attribute(const String& name, const String& value);
	void set_attribute(const String& name, int value);
	void set_attribute(const String& name);
	void unlink();
	xmlNodePtr get_node();
	xmlNodePtr get_parent() const;
	String get_path() const;
	xmlDocPtr get_document();
};

class XmlDocument
{
private:
	xmlDocPtr document;
	String url;

public:
	XmlDocument();	
	XmlDocument(const XmlDocument& document);
	XmlDocument(const String& url, bool create_if_dne = true);
	~XmlDocument();
	
	xmlDocPtr get_document()	{ return document; }
	String get_url()			{ return url; }
	
	void load(const String& url, bool create_if_dne = true);
	void save(const String& to);
	void save();
	xmlNodePtr get_root_node();
	xmlNodePtr create_root_node(const String& name);
	
	String to_string(gboolean pretty = false) const;
};

class XPathResult
{
private:
	xmlXPathObjectPtr result;
public:
	XPathResult(const XPathResult& result);
	XPathResult(xmlXPathObjectPtr result);
	~XPathResult();
	
	int get_count();
	xmlNodePtr get_result(int index);
};

class XPath
{
private:			
	xmlXPathContextPtr context;

	void create(xmlDocPtr document);

public:
	XPath(XmlDocument& document);
	XPath(XmlNode& node);
	XPath(xmlNodePtr node);
	XPath(xmlDocPtr document);
	~XPath();
	
	xmlXPathObjectPtr evaluate_expression(const String& expression);
	xmlNodePtr evaluate_expression_single(const String& expression);
};

#endif
