<?php
/**
 * Internationalisation file for the NewestPages extension
 * @addtogroup Extensions
 * @author Rob Church <robchur@gmail.com>
 * @copyright © 2006 Rob Church
 * @licence GNU General Public Licence 2.0
 */

$messages = array();

/** English
 * @author Rob Church
 */
$messages['en'] = array(
	'newestpages'            => 'Newest pages',
	'newestpages-desc'       => 'Shows the [[Special:Newestpages|last X pages]] added to the wiki',
	'newestpages-header'     => "'''This page lists the $1 newest pages on the wiki.'''",
	'newestpages-limitlinks' => 'Show up to $1 pages',
	'newestpages-namespace'  => 'Namespace:',
	'newestpages-none'       => 'No entries were found.',
	'newestpages-ns-header'  => "'''This page lists the $1 newest pages in the $2 namespace.'''",
	'newestpages-showing'    => 'Listing $1 newest pages:',
	'newestpages-submit'     => 'Go',
	'newestpages-showredir'  => 'Show redirect pages',
	'newestpages-hideredir'  => 'Hide redirect pages',
);

$messages['af'] = array(
	'newestpages-namespace' => 'Naamruimte:',
);

/** Old English (Anglo Saxon)
 * @author Wōdenhelm
 */
$messages['ang'] = array(
	'newestpages'         => 'Nīwost trametas',
	'newestpages-showing' => 'Ātellende $1 nīwoste trametas:',
	'newestpages-submit'  => 'Gā',
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'newestpages'            => 'أجدد الصفحات',
	'newestpages-desc'       => 'يعرض [[Special:Newestpages|آخر صفحات]] تمت إضافتها إلى الويكي',
	'newestpages-header'     => "'''هذه الصفحة تعرض أجدد $1 صفحة في الويكي.'''",
	'newestpages-limitlinks' => 'اعرض حتى $1 صفحة',
	'newestpages-namespace'  => 'النطاق:',
	'newestpages-none'       => 'لم يتم العثور على مدخلات.',
	'newestpages-ns-header'  => "'''هذه الصفحة تعرض أجدد $1 صفحة في نطاق $2.'''",
	'newestpages-showing'    => 'عرض أجدد $1 صفحة:',
	'newestpages-submit'     => 'اذهب',
	'newestpages-showredir'  => 'عرض صفحات التحويل',
	'newestpages-hideredir'  => 'إخفاء صفحات التحويل',
);

/** Kotava (Kotava)
 * @author Wikimistusik
 */
$messages['avk'] = array(
	'newestpages'            => 'Tel lowarzaf bueem',
	'newestpages-header'     => "'''Batu bu va telu $1 lowarzafu bu ke wiki vexalar.'''",
	'newestpages-limitlinks' => 'Kimara va $1 bu',
	'newestpages-namespace'  => 'Yoltxo :',
	'newestpages-none'       => 'Nedoy trasiks.',
	'newestpages-ns-header'  => "'''Batu bu va telu $1 lowarzafu bu koe $2 yoltxo vexalar.'''",
	'newestpages-showing'    => 'Vexalar va telu $1 lowarzafu bu :',
	'newestpages-submit'     => 'Skú !',
	'newestpages-showredir'  => 'Nedira va graskan bueem',
	'newestpages-hideredir'  => 'Palsera va graskan bueem',
);

$messages['bcl'] = array(
	'newestpages' => 'Mga pinakabâgong páhina',
	'newestpages-limitlinks' => 'Ipahiling hasta sa $1 na mga páhina',
	'newestpages-none' => 'Mayong nakuâng entrada.',
	'newestpages-submit' => 'Dumanán',
	'newestpages-hideredir' => 'Tagôon an mga redirektang páhina',
);

/** Bulgarian (Български)
 * @author Spiritia
 * @author DCLXVI
 */
$messages['bg'] = array(
	'newestpages'            => 'Най-нови страници',
	'newestpages-desc'       => 'Показва [[Special:Newestpages|последните Х страници]], създадени в уикито',
	'newestpages-header'     => "'''{{PLURAL:$1|Най-новата $1 страница|Списък на най-новите $1 страници}} в уикито.'''",
	'newestpages-limitlinks' => 'Показване най-много на $1 {{PLURAL:$1|страница|страници}}',
	'newestpages-namespace'  => 'Именно пространство:',
	'newestpages-none'       => 'Няма намерени записи.',
	'newestpages-ns-header'  => "'''{{PLURAL:$1|Най-новата $1 страница|Списък на най-новите $1 страници}} в именно пространство $2.'''",
	'newestpages-showing'    => 'Показване на $1 {{PLURAL:$1|най-нова страница|най-нови страници}}:',
	'newestpages-submit'     => 'Показване',
	'newestpages-showredir'  => 'Показване на пренасочващите страници',
	'newestpages-hideredir'  => 'Скриване на пренасочващите страници',
);

/** Catalan (Català)
 * @author SMP
 */
$messages['ca'] = array(
	'newestpages-submit' => 'Vés-hi',
);

/** Chamorro (Chamoru)
 * @author Jatrobat
 */
$messages['ch'] = array(
	'newestpages-submit' => 'Hånao',
);

/** Church Slavic (Словѣньскъ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'newestpages-submit' => 'прѣиди́',
);

/** Danish (Dansk)
 * @author Jon Harald Søby
 */
$messages['da'] = array(
	'newestpages-namespace' => 'Navnerum:',
);

/** German (Deutsch)
 * @author Markus Klatt
 * @author Raimond Spekking
 */
$messages['de'] = array(
	'newestpages'            => 'Neueste Seiten',
	'newestpages-desc'       => 'Zeigt die [[Special:Newestpages|neuesten X Seiten]] des Wikis',
	'newestpages-header'     => "'''Diese Seite listet die $1 neuesten Seiten dieses Wikis auf.'''",
	'newestpages-limitlinks' => 'Zeige $1 Seiten',
	'newestpages-namespace'  => 'Namensraum:',
	'newestpages-none'       => 'Kein Eintrag gefunden.',
	'newestpages-ns-header'  => "'''Diese Seite listet die $1 neuesten Seiten im Namensraum $2 auf.'''",
	'newestpages-showing'    => 'Die $1 neuesten Seiten:',
	'newestpages-submit'     => 'Suchen',
	'newestpages-showredir'  => 'Weiterleitungsseiten anzeigen',
	'newestpages-hideredir'  => 'Weiterleitungsseiten ausblenden',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Nepl1
 * @author Michawiki
 */
$messages['dsb'] = array(
	'newestpages'            => 'Nejnowše boki',
	'newestpages-desc'       => 'Pokazujo [[Special:Newestpages|nejnowšych X bokow]] wikija',
	'newestpages-header'     => "'''Toś ten bok nalicujo $1 nejnowšych bokow na toś tom wikiju.'''",
	'newestpages-limitlinks' => 'Pokaž {{Plural:$1|bok|boka|boki}}',
	'newestpages-namespace'  => 'Mjenjowy rum',
	'newestpages-none'       => 'Žedne zapise njejsu se namakali.',
	'newestpages-ns-header'  => "'''Toś ten bok nalicujo $1 nejnowšych bokow w mjenjowem rumje $2.'''",
	'newestpages-showing'    => 'Nejnowše $1 boki:',
	'newestpages-submit'     => 'Pytaś',
	'newestpages-showredir'  => 'Pśesměrowanja pokazaś',
	'newestpages-hideredir'  => 'Pśesměrowanja schowaś',
);

/** Greek (Ελληνικά)
 * @author Consta
 */
$messages['el'] = array(
	'newestpages'        => 'Νεώτερες σελίδες',
	'newestpages-submit' => 'Πηγαίνετε',
);

/** Esperanto (Esperanto)
 * @author Tlustulimu
 * @author Yekrats
 */
$messages['eo'] = array(
	'newestpages'            => 'Plej novaj paĝoj',
	'newestpages-desc'       => 'Montras la [[Special:Newestpages|plej novajn X paĝojn]] aldonitajn al la vikio.',
	'newestpages-header'     => "'''Ĉi tiu paĝo listigas la $1 plej novajn paĝojn en la vikio.'''",
	'newestpages-limitlinks' => 'Montru ĝis $1 paĝojn',
	'newestpages-namespace'  => 'Nomspaco:',
	'newestpages-none'       => 'Ne estis trovitaj iuj enskribaĵoj',
	'newestpages-ns-header'  => "'''Ĉi tiu paĝo listigas la $1 plej novajn paĝojn en la $2 nomspaco.'''",
	'newestpages-showing'    => 'Listigas la $1 plej novajn paĝojn:',
	'newestpages-submit'     => 'Ek',
	'newestpages-showredir'  => 'Montru alidirektajn paĝojn',
	'newestpages-hideredir'  => 'Kaŝu alidirektajn paĝojn',
);

/** Spanish (Español)
 * @author Jatrobat
 */
$messages['es'] = array(
	'newestpages-submit' => 'Ir',
);

/* Finnish (Niklas Laxström) */
$messages['fi'] = array(
	'newestpages' => 'Uusimmat sivut',
	'newestpages-header' => "'''Tällä sivulla on luettelo $1 uusimmasta sivusta tässä wikissä.'''",
	'newestpages-limitlinks' => 'Näytä enintään $1 sivua',
	'newestpages-namespace' => 'Nimiavaruus:',
	'newestpages-none' => 'Ei uusia sivuja.',
	'newestpages-ns-header' => "'''Tällä sivulla on luettelo $1 uusimmasta sivusta nimiavaruudessa $2.'''",
	'newestpages-showing' => 'Näytetään $1 uusinta sivua:',
	'newestpages-submit' => 'Hae',
	'newestpages-showredir' => 'Näytä uudelleenohjaukset',
	'newestpages-hideredir' => 'Piilota uudelleenohjaukset',
);

/** French (Français)
 * @author Grondin
 * @author Urhixidur
 */
$messages['fr'] = array(
	'newestpages'            => 'Pages les plus récentes',
	'newestpages-desc'       => 'Affiche les [[Special:Newestpages|dernières pages]] ajoutées au wiki.',
	'newestpages-header'     => "'''Cette page liste les $1 pages les plus récentes sur le wiki.'''",
	'newestpages-limitlinks' => 'Afficher jusqu’à $1 pages',
	'newestpages-namespace'  => 'Espace Wiki :',
	'newestpages-none'       => 'Aucune page n’a été trouvée',
	'newestpages-ns-header'  => "'''Cette page liste les $1 pages les plus récentes dans l’espace $2.'''",
	'newestpages-showing'    => 'Affichage des $1 pages les plus récentes :',
	'newestpages-submit'     => 'Lancer',
	'newestpages-showredir'  => 'Afficher les pages de redirection.',
	'newestpages-hideredir'  => 'Cacher les pages de redirection.',
);

/** Galician (Galego)
 * @author Alma
 * @author Xosé
 */
$messages['gl'] = array(
	'newestpages'            => 'Páxinas máis novas',
	'newestpages-desc'       => 'Amosa [[Special:Newestpages|X últimas páxinas]] engadidas ao wiki',
	'newestpages-header'     => "'''Esta páxina lista as $1 páxinas novas no wiki.'''",
	'newestpages-limitlinks' => 'Amosar $1 páxinas',
	'newestpages-namespace'  => 'Espazo de nomes:',
	'newestpages-none'       => 'Ningunhas entradas foron atopadas.',
	'newestpages-ns-header'  => "'''Esta páxina lista as $1 páxinas novas no espazo de nomes $2.'''",
	'newestpages-showing'    => 'Listando $1 páxinas novas:',
	'newestpages-submit'     => 'Ir',
	'newestpages-showredir'  => 'Amosar páxinas redirixidas',
	'newestpages-hideredir'  => 'Ocultar páxinas redirixidas',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'newestpages-submit' => 'Gow',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'newestpages'            => 'नवीनतम पन्ने',
	'newestpages-desc'       => 'विकिपर बनाये गये [[Special:Newestpages|आखिरी X पन्ने]] दर्शाता हैं',
	'newestpages-header'     => "'''यह पृष्ठ विकिपर बनाये गये आखिरी $1 पन्नोंकी सूची दर्शाता हैं।'''",
	'newestpages-limitlinks' => '$1 तक पन्ने दर्शायें',
	'newestpages-namespace'  => 'नामस्थान:',
	'newestpages-none'       => 'एन्ट्री मिली नहीं।',
	'newestpages-ns-header'  => "'''यह पृष्ठ $2 नामस्थानमें बनायें $1 नवीनतम पन्नोंकी सूची दर्शाता हैं।'''",
	'newestpages-showing'    => '$1 नवीनतम पन्नोंकी सूची:',
	'newestpages-submit'     => 'जायें',
	'newestpages-showredir'  => 'अनुप्रेषित पन्ने दर्शायें',
	'newestpages-hideredir'  => 'अनुप्रेषित पन्ने छुपायें',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'newestpages-submit' => 'Lakat',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'newestpages'            => 'Najnowše strony',
	'newestpages-desc'       => 'Pokazuje [[Special:Newestpages|poslednich X stronow]], kotrež je so wikiju přidało',
	'newestpages-header'     => "'''Tuta strona nalistuje $1 najnowšich stronow tutoho wikija.'''",
	'newestpages-limitlinks' => 'Do $1 stronow pokazać',
	'newestpages-namespace'  => 'Mjenowy rum',
	'newestpages-none'       => 'Žane zapiski namakane.',
	'newestpages-ns-header'  => "'''Tuta strona nalistuje $1 najnowšich stronow z mjenoweho ruma $2.'''",
	'newestpages-showing'    => '$1 najnowšich stronow:',
	'newestpages-submit'     => 'Pytać',
	'newestpages-showredir'  => 'Daleposrědkowanske strony pokazać',
	'newestpages-hideredir'  => 'Dalesposrědkowanske strony schować',
);

/** Hungarian (Magyar)
 * @author Dani
 */
$messages['hu'] = array(
	'newestpages'            => 'Legújabb lapok',
	'newestpages-header'     => "'''Ezen az oldalon a wiki $1 legújabb lapja látható.'''",
	'newestpages-limitlinks' => '$1 oldal megjelenítése',
	'newestpages-namespace'  => 'Névtér:',
	'newestpages-none'       => 'Nincsenek találatok.',
	'newestpages-ns-header'  => "'''Ez az oldal a wiki $1 legújabb lapját listázza a(z) $2 névtérben.'''",
	'newestpages-showing'    => '$1 legújabb lap listázása:',
	'newestpages-submit'     => 'Megjelenítés',
	'newestpages-showredir'  => 'Átirányítások mutatása',
	'newestpages-hideredir'  => 'Átirányítások elrejtése',
);

/* Indonesian (Ivan Lanin) */
$messages['id'] = array(
	'newestpages' => 'Halaman terbaru',
	'newestpages-header' => "'''Halaman ini memberikan daftar $1 halaman terbaru di wiki ini.'''",
	'newestpages-limitlinks' => 'Menampilkan sampai $1 halaman',
	'newestpages-namespace' => 'Ruang nama:',
	'newestpages-none' => 'Tidak ditemukan entri.',
	'newestpages-ns-header' => "'''Halaman ini memberikan daftar $1 halaman terbaru di ruang nama $2.'''",
	'newestpages-showing' => 'Menampilkan $1 halaman terbaru:',
	'newestpages-submit' => 'Cari',
	'newestpages-showredir' => 'Tampilkan halaman pengalihan',
	'newestpages-hideredir' => 'Sembunyikan halaman pengalihan',
);

$messages['is'] = array(
	'newestpages' => 'Nýjustu síður',
	'newestpages-header' => '\'\'\'Þessi síða listar $1 nýjustu síðurnar á þessu wiki.\'\'\'',
	'newestpages-limitlinks' => 'Sýna að hámarki $1 síður',
	'newestpages-namespace' => 'Nafnrými:',
	'newestpages-ns-header' => '\'\'\'Þessi síða listar $1 nýjustu síðurnar í $2 nafnrýminu.\'\'\'',
	'newestpages-showing' => 'Lista $1 nýjustu síðurnar:',
	'newestpages-submit' => 'Áfram',
	'newestpages-showredir' => 'Sýna tilvísanir',
	'newestpages-hideredir' => 'Fela tilvísanir',
);

/* Italian (BrokenArrow) */
$messages['it'] = array(
	'newestpages' => 'Pagine più recenti',
	'newestpages-header' => "'''In questa pagina vengono elencate le $1 pagine create più di recente nel sito.'''",
	'newestpages-limitlinks' => 'Mostra fino a $1 pagine',
	'newestpages-namespace' => 'Namespace:',
	'newestpages-none' => 'Nessuna pagina trovata.',
	'newestpages-ns-header' => "'''In questa pagina vengono elencate le $1 pagine create più di recente nel namespace $2.'''",
	'newestpages-showing' => 'Elenco delle $1 pagine create più di recente:',
	'newestpages-submit' => 'Vai',
	'newestpages-showredir' => 'Mostra i redirect',
	'newestpages-hideredir' => 'Nascondi i redirect',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'newestpages'            => 'Kaca-kaca anyar',
	'newestpages-limitlinks' => 'Tuduhna nganti tekan $1 kaca-kaca',
	'newestpages-namespace'  => 'Bilik nama:',
	'newestpages-none'       => 'Ora ditemokaké èntri.',
	'newestpages-submit'     => 'Golèk',
	'newestpages-showredir'  => 'Tuduhna kaca-kaca pangalihan',
	'newestpages-hideredir'  => 'Delikna kaca-kaca pangalihan',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Lovekhmer
 */
$messages['km'] = array(
	'newestpages'            => 'ទំព័រថ្មីៗបំផុត',
	'newestpages-desc'       => 'បង្ហាញ [[Special:Newestpages|ទំព័រ ចុងក្រោយបំផុត]] ដែលបានបន្ថែម ទៅ វិគី',
	'newestpages-header'     => "'''ទំព័រនេះ ​រាយ $1 ទំព័រ ថ្មីបំផុត លើ វិគី ។'''",
	'newestpages-limitlinks' => 'បង្ហាញអតិបរិមា $1 ទំព័រ',
	'newestpages-namespace'  => 'លំហឈ្មោះ៖',
	'newestpages-none'       => 'រកមិនឃើញ អត្ថបទ ។',
	'newestpages-ns-header'  => "'''ទំព័រនេះ ​រាយ $1 ទំព័រ ថ្មីបំផុត ក្នុង វាលឈ្មោះ $2 ។'''",
	'newestpages-showing'    => 'រាយ $1 ទំព័រ ថ្មីបំផុត ៖',
	'newestpages-submit'     => 'ទៅ',
	'newestpages-showredir'  => 'បង្ហាញទំព័របញ្ជូន',
	'newestpages-hideredir'  => 'បិទបាំង ទំព័រប្តូរទិស',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'newestpages-submit' => 'Agto',
);

/** Ripoarisch (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'newestpages-submit' => 'Loß Jonn!',
);

$messages['la'] = array(
	'newestpages-namespace' => 'Spatium nominale:',
	'newestpages-submit' => 'Ire',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'newestpages'            => 'Neitste Säiten',
	'newestpages-desc'       => 'Weist déi [[Special:Newestpages|läscht X Säiten]] déi op enger Wiki opgemaach goufen',
	'newestpages-header'     => "'''Op dëser Säit stinn déi $1 neitste Säite vun dëser Wiki.'''",
	'newestpages-limitlinks' => 'Weis bis zu $1 Säiten',
	'newestpages-namespace'  => 'Nummraum:',
	'newestpages-none'       => 'Näischt fonnt.',
	'newestpages-ns-header'  => "'''Op dëse Säite stinn déi $1 neitste Säiten aus dem Nummraum $2.'''",
	'newestpages-showing'    => 'Déi $1 neitste Säiten:',
	'newestpages-submit'     => 'Sichen',
	'newestpages-showredir'  => 'Weis Redirect-Säiten',
	'newestpages-hideredir'  => 'Verstopp Redirect-Säiten',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'newestpages'            => 'ഏറ്റവും പുതിയ താളുകള്‍',
	'newestpages-desc'       => 'വിക്കിയിലേക്കു [[Special:Newestpages|അവസാനമായി ചേര്‍ക്കപ്പെട്ട X താളുകള്‍]] പ്രദര്‍ശിപ്പിക്കുന്നു.',
	'newestpages-header'     => "'''വിക്കിയിലെ ഏറ്റവും പുതിയ $1 താളുകള്‍ ഈ താളില്‍ പ്രദര്‍ശിപ്പിച്ചിരിക്കുന്നു.'''",
	'newestpages-limitlinks' => '$1 താളുകള്‍ വരെ പ്രദര്‍ശിപ്പിക്കുന്നു',
	'newestpages-namespace'  => 'നേംസ്പേസ്:',
	'newestpages-none'       => 'എന്‍‌ട്രികള്‍ ഒന്നും കണ്ടില്ല.',
	'newestpages-ns-header'  => "'''ഈ താള്‍ $2 നേംസ്പേസിലുള്ള ഏറ്റവും പുതിയ $1 താളുകള്‍ പ്രദര്‍ശിപ്പിക്കുന്നു.'''",
	'newestpages-showing'    => 'ഏറ്റവും പുതിയ $1 താളുകള്‍ പ്രദര്‍ശിപ്പിക്കുന്നു:',
	'newestpages-submit'     => 'പോകൂ',
	'newestpages-showredir'  => 'തിരിച്ചുവിടല്‍ താളുകള്‍ പ്രദര്‍ശിപ്പിക്കുക',
	'newestpages-hideredir'  => 'തിരിച്ചുവിടല്‍ താളുകള്‍ മറയ്ക്കുക',
);

/** Marathi (मराठी)
 * @author Kaustubh
 */
$messages['mr'] = array(
	'newestpages'            => 'नवीनतम पाने',
	'newestpages-desc'       => 'विकिवर वाढविण्यात आलेली [[Special:Newestpages|शेवटची X पाने]] दर्शवितो',
	'newestpages-header'     => "'''हे पान विकिवर वाढविण्यात आलेल्या शेवटच्या $1 पानांची यादी देते.'''",
	'newestpages-limitlinks' => '$1 पर्यंतची पाने दाखवा',
	'newestpages-namespace'  => 'नामविश्व:',
	'newestpages-none'       => 'नोंदी सापडल्या नाहीत.',
	'newestpages-ns-header'  => "'''हे पान $2 नामविश्वातील $1 नवीनतम पानांची यादी देते.'''",
	'newestpages-showing'    => '$1 नवीनतम पानांची यादी:',
	'newestpages-submit'     => 'जा',
	'newestpages-showredir'  => 'पुनर्निर्देशन पाने दाखवा',
	'newestpages-hideredir'  => 'पुनर्निर्देशन पाने लपवा',
);

$messages['nds'] = array(
	'newestpages' => 'Ne’este Sieden',
	'newestpages-header' => '\'\'\'Disse Siet wiest de $1 ne’esten Sieden op dat Wiki.\'\'\'',
	'newestpages-limitlinks' => '$1 Sieden wiesen',
	'newestpages-namespace' => 'Naamruum:',
	'newestpages-none' => 'Nix funnen',
	'newestpages-ns-header' => '\'\'\'Disse Siet wiest de $1 ne’esten Sieden in’n Naamruum $2.\'\'\'',
	'newestpages-showing' => '$1 ne’este Sieden wiesen:',
	'newestpages-submit' => 'Los',
	'newestpages-showredir' => 'Wiederleiden wiesen',
	'newestpages-hideredir' => 'Wiederleiden nich wiesen',
);

/** Dutch (Nederlands)
 * @author Siebrand
 * @author SPQRobin
 */
$messages['nl'] = array(
	'newestpages'            => "Nieuwe pagina's",
	'newestpages-desc'       => "De [[Special:Newestpages|laatste X nieuwe pagina's]] in de wiki",
	'newestpages-header'     => "'''Op deze pagina staan de $1 meest recent aangemaakte pagina's van deze wiki.'''",
	'newestpages-limitlinks' => "Geeft maximaal $1 pagina's weer",
	'newestpages-namespace'  => 'Naamruimte:',
	'newestpages-none'       => 'Geen resultaten.',
	'newestpages-ns-header'  => "'''Deze pagina geeft de $1 meest recente aangemaakte pagina's weer in de naamruimte $2.'''",
	'newestpages-showing'    => "De $1 meest recente pagina's worden weergegeven:",
	'newestpages-submit'     => 'OK',
	'newestpages-showredir'  => 'Doorverwijzingen weergeven',
	'newestpages-hideredir'  => 'Doorverwijzingen verbergen',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Jon Harald Søby
 */
$messages['nn'] = array(
	'newestpages-namespace' => 'Namnerom:',
);

/** Norwegian (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'newestpages'            => 'Nyeste sider',
	'newestpages-desc'       => 'Viser de [[Special:Newestpages|siste X sidene]] som er lagt til på wikien',
	'newestpages-header'     => "'''Denne siden lister opp de $1 nyeste sidene på denne wikien.'''",
	'newestpages-limitlinks' => 'Vis opptil $1 sider',
	'newestpages-namespace'  => 'Navnerom:',
	'newestpages-none'       => 'Ingenting funnet.',
	'newestpages-ns-header'  => "'''Denne siden lister opp de $1 nyeste sidene i navnerommet $2.'''",
	'newestpages-showing'    => 'Lister opp de $1 nyeste sidene:s',
	'newestpages-submit'     => 'Gå',
	'newestpages-showredir'  => 'Vis omdirigeringer',
	'newestpages-hideredir'  => 'Skjul omdirigeringer',
);

/** Northern Sotho (Sesotho sa Leboa)
 * @author Mohau
 */
$messages['nso'] = array(
	'newestpages-submit' => 'Sepela',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'newestpages'            => 'Paginas mai recentas',
	'newestpages-desc'       => 'Aficha las [[Special:Newestpages|darrièras paginas]] ajustadas al wiki.',
	'newestpages-header'     => "'''Aquesta pagina lista las $1 paginas mai recentas sul wiki.'''",
	'newestpages-limitlinks' => 'Afichar fins a $1 paginas',
	'newestpages-namespace'  => 'Espaci de nom :',
	'newestpages-none'       => 'Cap de pagina es pas estada trobada',
	'newestpages-ns-header'  => "'''Aquesta pagina lista las $1 paginas mai recentas dins l’espaci $2.'''",
	'newestpages-showing'    => 'Afichatge de las $1 paginas mai recentas :',
	'newestpages-submit'     => 'Amodar',
	'newestpages-showredir'  => 'Afichar las paginas de redireccion.',
	'newestpages-hideredir'  => 'Amagar las paginas de redireccion.',
);

$messages['pl'] = array(
	'newestpages' => 'Najnowsze strony',
	'newestpages-header' => '\'\'\'Ta strona pokazuje $1 najnowszych stron na tej wiki.\'\'\'',
	'newestpages-limitlinks' => 'Pokaż do $1 stron',
	'newestpages-namespace' => 'Przestrzeń nazw:',
	'newestpages-none' => 'Nie znaleziono żadnych wpisów.',
	'newestpages-ns-header' => '\'\'\'Ta strona pokazuje $1 najnowszych stron w przestrzeni nazw $2.\'\'\'',
	'newestpages-showing' => 'Prezentowanie $1 najnowszych stron:',
	'newestpages-submit' => 'Pokaż',
	'newestpages-showredir' => 'Pokaż strony przekierowujące',
	'newestpages-hideredir' => 'Ukryj strony przekierowujące',
);

$messages['pms'] = array(
	'newestpages' => 'Pàgine pì neuve',
	'newestpages-header' => '\'\'\'Ambelessì a-i é la lista dle $1 pàgine pì neuve dla wiki.\'\'\'',
	'newestpages-limitlinks' => 'Smon fin a $1 pàgine',
	'newestpages-namespace' => 'Spassi nominal:',
	'newestpages-none' => 'Gnun-a vos trovà.',
	'newestpages-ns-header' => '\'\'\'Ambelessì a-i é la lista dle $1 pàgine pì neuve dlë spassi nominal $2.\'\'\'',
	'newestpages-showing' => 'Lista dle $1 pàgine pì neuve:',
	'newestpages-submit' => 'Va',
	'newestpages-showredir' => 'Smon j\'ardiression',
	'newestpages-hideredir' => 'Stërma j\'ardiression',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'newestpages'            => 'تر ټولو نوي مخونه',
	'newestpages-limitlinks' => 'تر $1 پورې مخونه ښکاره کړی',
	'newestpages-namespace'  => 'نوم-تشيال:',
	'newestpages-submit'     => 'ورځه',
);

/* Portuguese (Lugusto) */
$messages['pt'] = array(
	'newestpages' => 'Páginas novas',
	'newestpages-header' => "'''Esta página lista as $1 páginas mais recentes deste wiki.'''",
	'newestpages-limitlinks' => 'Exibir até $1 páginas',
	'newestpages-namespace' => 'Espaço nominal:',
	'newestpages-none' => 'Não foram encontrados resultados.',
	'newestpages-ns-header' => "'''Esta página lista as $1 páginas mais recentes do espaço nominal $2.'''",
	'newestpages-showing' => 'Listando as $1 páginas mais recentes:',
	'newestpages-submit' => 'Ir',
	'newestpages-showredir' => 'Exibir redireccionamentos',
	'newestpages-hideredir' => 'Ocultar redireccionamentos',
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'newestpages'            => 'Новые страницы',
	'newestpages-desc'       => 'Показывает [[Special:Newestpages|последние X страниц]] добавленных в вики',
	'newestpages-header'     => "'''Эта страница в ходит в список $1 новых страниц этой вики.'''",
	'newestpages-limitlinks' => 'Показывать до $1 страниц',
	'newestpages-namespace'  => 'Пространство имён:',
	'newestpages-none'       => 'Не найдено записей.',
	'newestpages-ns-header'  => "'''Эта страница входит в список $1 новых страниц пространства имён $2.'''",
	'newestpages-showing'    => 'Список $1 новых страниц:',
	'newestpages-submit'     => 'Выполнить',
	'newestpages-showredir'  => 'Показывать страницы-перенаправления',
	'newestpages-hideredir'  => 'Скрыть страницы-перенаправления',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'newestpages'            => 'Najnovšie stránky',
	'newestpages-desc'       => 'Zobrazuje [[Special:Newestpages|posledných X stránok]] pridaných na wiki',
	'newestpages-header'     => "'''Toto je zoznam $1 najnovších stránok na wiki.'''",
	'newestpages-limitlinks' => 'Zobraziť najviac $1 stránok',
	'newestpages-namespace'  => 'Menný priestor:',
	'newestpages-none'       => 'Neboli nájdené žiadne záznamy.',
	'newestpages-ns-header'  => "'''Toto je zoznam $1 najnovších stránok v mennom priestore $2.'''",
	'newestpages-showing'    => 'Zoznam $1 najnovších stránok:',
	'newestpages-submit'     => 'Vykonať',
	'newestpages-showredir'  => 'Zobraziť presmerovacie stránky',
	'newestpages-hideredir'  => 'Skryť presmerovacie stránky',
);

/* Serbian default (Sasa Stefanovic) */
$messages['sr'] = array(
	'newestpages' => 'Најновије странице',
	'newestpages-header' => "'''Ова страница показује $1 најновијих страница на Вики.'''",
	'newestpages-limitlinks' => 'Прикажи $1 страница',
	'newestpages-namespace' => 'Именски простор:',
	'newestpages-none' => 'Није ништа пронађено.',
	'newestpages-ns-header' => "'''Ова страница показује $1 најновијих страница у $2 именском простору.'''",
	'newestpages-showing' => 'Приказ $1 најновијих страница:',
	'newestpages-submit' => 'Иди',
	'newestpages-showredir' => 'Прикажи странице преусмерења',
	'newestpages-hideredir' => 'Сакриј странице преусмерења',
);

/* Serbian cyrillic (Sasa Stefanovic) */
$messages['sr-ec'] = array(
	'newestpages' => 'Најновије странице',
	'newestpages-header' => "'''Ова страница показује $1 најновијих страница на Вики.'''",
	'newestpages-limitlinks' => 'Прикажи $1 страница',
	'newestpages-namespace' => 'Именски простор:',
	'newestpages-none' => 'Није ништа пронађено.',
	'newestpages-ns-header' => "'''Ова страница показује $1 најновијих страница у $2 именском простору.'''",
	'newestpages-showing' => 'Приказ $1 најновијих страница:',
	'newestpages-submit' => 'Иди',
	'newestpages-showredir' => 'Прикажи странице преусмерења',
	'newestpages-hideredir' => 'Сакриј странице преусмерења',
);

/* Serbian latin (Sasa Stefanovic) */
$messages['sr-el'] = array(
	'newestpages' => 'Najnovije stranice',
	'newestpages-header' => "'''Ova stranica pokazuje $1 najnovijih stranica na Viki.'''",
	'newestpages-limitlinks' => 'Prikaži $1 stranica',
	'newestpages-namespace' => 'Imenski prostor:',
	'newestpages-none' => 'Nije ništa pronađeno.',
	'newestpages-ns-header' => "'''Ova stranica pokazuje $1 najnovijih stranica u $2 imenskom prostoru.'''",
	'newestpages-showing' => 'Prikaz $1 najnovijih stranica:',
	'newestpages-submit' => 'Idi',
	'newestpages-showredir' => 'Prikaži stranice preusmerenja',
	'newestpages-hideredir' => 'Sakrij stranice preusmerenja',
);

$messages['ss'] = array(
	'newestpages-submit' => 'Kúhámba',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'newestpages'            => 'Näiste Sieden',
	'newestpages-header'     => "'''Disse Siede liestet do $1 näiste Sieden fon dit Wiki ap.'''",
	'newestpages-limitlinks' => 'Wies $1 Sieden',
	'newestpages-namespace'  => 'Noomensruum:',
	'newestpages-none'       => 'Naan Iendraach fuunen.',
	'newestpages-ns-header'  => "'''Disse Siede liestet do $1 näiste Sieden in dän Noomensruum $2 ap.'''",
	'newestpages-showing'    => 'Do $1 näiste Sieden:',
	'newestpages-submit'     => 'Säike',
	'newestpages-showredir'  => 'Wiederlaitengssieden anwiese',
	'newestpages-hideredir'  => 'Wiederlaitengssieden ferstopje.',
);

/** Sundanese (Basa Sunda)
 * @author Kandar
 */
$messages['su'] = array(
	'newestpages'            => 'Kaca-kaca panganyarna',
	'newestpages-desc'       => 'Témbongkeun [[Special:Newestpages|X kaca panungtung]] nu dijieun di wiki',
	'newestpages-header'     => "'''Ieu kaca ngabéréndélkeun $1 kaca panganyarna di wiki.'''",
	'newestpages-limitlinks' => 'Témbongkeun nepi ka $1 kaca',
	'newestpages-namespace'  => 'Spasi ngaran:',
	'newestpages-none'       => 'Euweuh éntri nu kapanggih.',
	'newestpages-ns-header'  => "'''Ieu kaca ngabéréndélkeun $1 kaca panganyarna dina ngaran spasi $2.'''",
	'newestpages-showing'    => 'Ngabéréndélkeun $1 kaca panganyarna:',
	'newestpages-submit'     => 'Jung',
	'newestpages-showredir'  => 'Témbongkeun kaca alihan',
	'newestpages-hideredir'  => 'Sumputkeun kaca alihan',
);

/** Swedish (Svenska)
 * @author M.M.S.
 * @author M.M.S.
 * @author Sannab
 */
$messages['sv'] = array(
	'newestpages'            => 'Nyaste sidor',
	'newestpages-desc'       => 'Visar de [[Special:Newestpages|senaste X sidorna]] som lagts till i wikin',
	'newestpages-header'     => "'''Denna sida listar de $1 nyaste sidorna på denna wiki.'''",
	'newestpages-limitlinks' => 'Visa upp till $1 sidor',
	'newestpages-namespace'  => 'Namnrymd:',
	'newestpages-none'       => 'Inga entréer hittades.',
	'newestpages-ns-header'  => "'''Denna sida listar de $1 nyaste sidorna i $2 namnrymden.'''",
	'newestpages-showing'    => 'Listar de $1 nyaste sidorna:',
	'newestpages-submit'     => 'Gå',
	'newestpages-showredir'  => 'Visa omdirigerings sidor',
	'newestpages-hideredir'  => 'Dölj omdirigerings sidor',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'newestpages'            => 'కొంగొత్త పేజీలు',
	'newestpages-desc'       => 'వికీలో చేర్చిన [[Special:Newestpages|చివరి X పేజీల]]ను చూపిస్తుంది',
	'newestpages-header'     => "'''ఈ వికీలోని $1 కొంగొత్త పేజీలను ఈ పేజీ చూపిస్తుంది.'''",
	'newestpages-limitlinks' => '$1 పేజీల వరకు చూపించు',
	'newestpages-none'       => 'ఏమీ కనబడలేదు.',
	'newestpages-showing'    => '$1 కొంగొత్త పేజీలను చూపిస్తున్నాం:',
	'newestpages-submit'     => 'వెళ్ళు',
	'newestpages-showredir'  => 'దారిమార్పు పేజీలను చూపించు',
	'newestpages-hideredir'  => 'దారిమార్పు పేజీలను దాచు',
);

/** Tetum (Tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'newestpages-submit' => 'Bá',
);

/** Tajik (Cyrillic) (Тоҷикӣ/tojikī (Cyrillic))
 * @author Ibrahim
 * @author Siebrand
 */
$messages['tg-cyrl'] = array(
	'newestpages'           => 'Саҳифаҳои навтарин',
	'newestpages-namespace' => 'Фазоином:',
	'newestpages-ns-header' => "'''Ин саҳифа $1 навтарин саҳифаҳоро дар фазоиноми $2 феҳрист мекунад.'''",
	'newestpages-submit'    => 'Бирав',
	'newestpages-showredir' => 'Намоиши саҳифаҳои масир',
	'newestpages-hideredir' => 'Пинҳон кардани саҳифаҳои масир',
);

/** Tonga (faka-Tonga)
 * @author Tauʻolunga
 */
$messages['to'] = array(
	'newestpages'            => 'Ngaahi peesi foʻou taha',
	'newestpages-header'     => "'''ʻOku lisi ʻi he pēsí ni ko e ngaahi peesi foʻou ʻe $1 ʻo e ''wiki'' ʻeni.'''",
	'newestpages-limitlinks' => 'ʻAsi mai ha ngaahi peesi aʻu ki he $1',
	'newestpages-namespace'  => 'Vā hingoa:',
	'newestpages-none'       => 'Naʻe ʻikai ʻilo ha lēkoti',
	'newestpages-ns-header'  => "'''ʻOku lisi ʻi he pēsí ni ko e ngaahi peesi foʻou ʻe $1 ʻi he vā hingoa $2.'''",
	'newestpages-showing'    => 'ʻOku lisi ha peesi foʻou taha ʻe $1:',
	'newestpages-submit'     => 'Fai ā',
	'newestpages-showredir'  => 'ʻAsi ha ngaahi kupu fakaʻuhingakehe',
	'newestpages-hideredir'  => 'Toi ha ngaahi kupu fakaʻuhingakehe',
);

/** Turkish (Türkçe)
 * @author Karduelis
 */
$messages['tr'] = array(
	'newestpages'        => 'En yeni sayfalar',
	'newestpages-submit' => 'Git',
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'newestpages'            => 'Pagine piassè nove',
	'newestpages-desc'       => 'Mostra le [[Special:Newestpages|ultime X pagine]] zontà a la wiki',
	'newestpages-header'     => "'''Sta pagina la elenca le $1 pagine piassè nove su la wiki.'''",
	'newestpages-limitlinks' => 'Mostra fin a $1 pagine',
	'newestpages-namespace'  => 'Namespace:',
	'newestpages-none'       => 'No xe stà catà nissuna pagina.',
	'newestpages-ns-header'  => "'''Sta pagina la elenca le $1 pagine piassè nove nel namespace $2.'''",
	'newestpages-showing'    => 'Elenco de le $1 pagine piassè nove:',
	'newestpages-submit'     => 'Và',
	'newestpages-showredir'  => 'Mostra i redirect',
	'newestpages-hideredir'  => 'Scondi i redirect',
);

/** Vietnamese (Tiếng Việt)
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'newestpages'            => 'Các trang mới nhất',
	'newestpages-header'     => "'''Trang này liệt kê $1 trang mới nhất trên wiki.'''",
	'newestpages-limitlinks' => 'Hiển thị tối đa $1 trang',
	'newestpages-namespace'  => 'Không gian:',
	'newestpages-none'       => 'Không tìm thấy mục nào.',
	'newestpages-ns-header'  => "'''Trang nay liệt kê $1 trang mới nhất trong không gian tên $2.'''",
	'newestpages-showing'    => 'Liệt kê $1 trang mới nhất:',
	'newestpages-submit'     => 'Xem',
	'newestpages-showredir'  => 'Hiện các trang đổi hướng',
	'newestpages-hideredir'  => 'Ẩn các trang đổi hướng',
);

/* Cantonese (Hillgentleman, Shinjiman) */
$messages['yue'] = array(
	'newestpages' => '新頁',
	'newestpages-header' => "'''呢度列舉成個維基入面最新 $1 頁。'''",
	'newestpages-limitlinks' => '攤開頂龍 $1 版',
	'newestpages-namespace' => '空間名:',
	'newestpages-none' => '乜都揾唔到。',
	'newestpages-ns-header' => "'''呢度列舉$2 空間名裏面最新 $1 篇文。'''",
	'newestpages-showing' => '攤開最新$1 篇文：',
	'newestpages-submit' => '去',
	'newestpages-showredir' => '攤開啲跳轉頁',
	'newestpages-hideredir' => '摺埋啲跳轉頁',
);

/* Chinese (Simplified) (下一次登录) */
$messages['zh-hans'] = array(
	'newestpages' => '最新页面',
	'newestpages-header' => "'''本页面列举维基上第$1新的页面。'''",
	'newestpages-limitlinks' => '显示$1个页面',
	'newestpages-namespace' => '名字空间：',
	'newestpages-none' => '没找到页面。',
	'newestpages-ns-header' => "'''本页面列举$2名字空间中第$1新的页面。'''",
	'newestpages-showing' => '正在列举第$1新的页面：',
	'newestpages-submit' => '提交',
	'newestpages-showredir' => '显示重定向页面',
	'newestpages-hideredir' => '隐藏重定向页面',
);

/* Chinese (Traditional) (KilluaZaoldyeck, Shinjiman) */
$messages['zh-hant'] = array(
	'newestpages' => '最新頁面',
	'newestpages-header' => "'''本頁列出維基上第$1新的頁面。'''",
	'newestpages-limitlinks' => '顯示$1個頁面',
	'newestpages-namespace' => '名字空間：',
	'newestpages-none' => '沒找到頁面。',
	'newestpages-ns-header' => "'''本頁列出$2名字空間中第$1個新的頁面。'''",
	'newestpages-showing' => '正在列出第$1個新的頁面：',
	'newestpages-submit' => '提交',
	'newestpages-showredir' => '顯示重定向頁面',
	'newestpages-hideredir' => '隱藏重定向頁面',
);

