/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
/*
 * $Id: dictionary.h,v 1.2 2003/02/05 04:38:37 kos Exp $
 *
 * killdupes saves some speed when killing dupes is costlier than
 * doing another hash generate/compare (look at sha1 8)
 */

#ifndef _DICTIONARY_H
#define _DICTIONARY_H

#include <stdio.h>
#include "array.h"
#include "keyspace.h"
#include "generator.h"

#define DICT_MINLEN 1
#define DICT_MAXLEN 8
#define DICT_WORDSFILE "/usr/dict/words"
#define DICT_RULESFILE "rules"
#define DICT_KILLDUPES 1
#define DICT_FILESERVER "localhost"
#define DICT_FILEPORT "5444"
#define DICT_TEMPDIR "/tmp"

#define DICT_F_RULES 1
#define DICT_F_WORDS 2

#define DICT_LINELEN 1024
#define WORD_LINELEN 256

#ifndef PATH_SEPARATOR
#ifdef unix
#define PATH_SEPARATOR '/'
#else
#define PATH_SEPARATOR '\\'
#endif
#endif

typedef struct dictionary_t {
  key_index_t index;
  key_index_t minindex;
  key_index_t maxindex;
  /* */
  int minlen;
  int maxlen;
  char wordsfile[DICT_LINELEN];
  char rulesfile[DICT_LINELEN];
  char fileserver[DICT_LINELEN];
  char fileport[DICT_LINELEN];
  char tempdir[DICT_LINELEN];
  /* */
  array *rules;
  array *words;
  int rule_index;
  int word_index;
  int killdupes;
  char prevword[DICT_LINELEN];
} dictionary_t;

dictionary_t *dictionary_init(char *opts);
int dictionary_set(dictionary_t *, key_index_t index);
int dictionary_fetch(dictionary_t *, kchar *buf, int len, int *rlen);
int dictionary_done(dictionary_t *);
int dictionary_destroy(dictionary_t *);
key_index_t *dictionary_minindex(dictionary_t *);
key_index_t *dictionary_maxindex(dictionary_t *);
key_index_t *dictionary_curindex(dictionary_t *);
int dictionary_minlen(dictionary_t *);
int dictionary_maxlen(dictionary_t *);

#endif /* _DICTIONARY_H */
