/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: testcrypt.c,v 1.7 2003/02/05 04:40:14 kos Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#include "array.h"
#include "method.h"
#include "llog.h"

void
usage(char *argv0, int code) {
  fprintf(stderr, "Usage: %s [options]\n\
\t-V: Print version string\n\
\t-l: Dump list of methods available\n\
\t-v: Verbosity (default: %d)\n\
\t-t: Crypt type (default: %s)\n\
\t-o: Crypt options (default: %s)\n\
\t-h: Hash (default: %s)\n\
\t-k: Key (default: %s)\n",
	  argv0, 9, "unixcrypt", "", "aapmDihkgvxcs", "test01");
  exit(code);
}

int
dostuff(char *type, char *opts, char *hash, char *key) {
  method_t *m;
  int i;
  int limit;
  time_t now;
  time_t then;
  int cps;
  
  if(!(m=method_init(type, opts))) {
    llog(1, "method_init(%s, %s): failed\n", type, opts);
    return 1;
  }

  limit = method_siz(m);
  method_sethash(m, hash, strlen(hash));

  llog(1, "preparing for %d crypts...\n", limit);
  cps=0;
  now = time(NULL);
  for(i=0; i<limit; i++)
    method_add(m, key, 0);
  if(method_crypt(m)) {
    llog(1, "strange: crypt() actually found the key\n");
  } else {
    then = time(NULL);
    cps = limit / ((int)(then-now));
    llog(1, "crypt() finished. %d crypts per second\n", cps);
  }
  return 0;
}

int
main(int argc, char **argv) {
  char c;
  int verbose;
  char type[METH_LINELEN];
  char opts[METH_LINELEN];
  char hash[METH_LINELEN];
  char key[METH_LINELEN];
  int i;

  strcpy(type, "unixcrypt");
  strcpy(opts, "");
  strcpy(hash, "aapmDihkgvxcs");
  strcpy(key, "test01");
  verbose = 9;

  while((c = getopt(argc, argv, "v:o:t:h:k:lV")) != EOF) {
    switch(c) {
    case 'v':
      verbose = atoi(optarg);
      break;
    case 't':
      strncpy(type, optarg, METH_LINELEN);
      break;
    case 'o':
      strncpy(opts, optarg, METH_LINELEN);
      break;
    case 'h':
      strncpy(hash, optarg, METH_LINELEN);
      break;
    case 'k':
      strncpy(key, optarg, METH_LINELEN);
      break;
    case 'l':
      printf("Available methods: ");
      for(i=0; !method_query(i, type, METH_LINELEN); i++)
	printf("%s ", type);
      printf("\n");
      exit(0);
      break;
    case 'V':
      printf("testcrypt version %s\n", VERSION);
      exit(0);
    case '?':
      usage(argv[0], 1);
      break;
    }
  }

  llog_init(LLOG_STDERR);
  llog_level(9);
  llog(1, "method %s, options %s\n", type, opts);
  dostuff(type, opts, hash, key);  
  exit(0);
}
