package Memories::Tag;
use strict;
use base qw(Memories::DBI Maypole::Model::CDBI::Plain);
__PACKAGE__->columns(Essential => qw/id name/);

Memories::Photo->set_sql(sorted_by_tag => q/
SELECT photo.id as id, title, uploader, uploaded, x, y
FROM photo, tag, tagging
WHERE tagging.photo = photo.id
    AND tagging.tag = tag.id
    AND tag.id = ?
ORDER BY photo.uploaded DESC
/
);

sub view :Exported {
    my ($self, $r) = @_;
    my $tag;
    my $page = $r->params->{page} || 1;
    my $pager = Class::DBI::Pager::_pager("Memories::Photo",
        Memories->config->{photos_per_page}, $page);
    $r->{template_args}{pager} = $pager;
    my @tags = map { $self->search(name => $_)->first } @{$r->args};

    if (@{$r->args} > 1) { # This is actually an n-level search
        my $sth = $self->multi_search(@tags);
        $r->{template_args}{photos} = [ $r->{template_args}{pager}->sth_to_objects($sth) ];
        $sth->finish;
        $r->{template_args}{tags} = \@tags;
    } else {
        if (!$r->objects) {
            $tag = $tags[0];
        } else {
            $tag = $r->objects->[0];
        }
        $r->{template_args}{tag} = $tag;
        $r->{template_args}{tags} = [$tag]; # For selector
        $r->{template_args}{photos} =
            [$pager->search_sorted_by_tag($tag->id)];
    }
}

sub multi_search {
    my ($self, @tags) = @_;
    my $counter = "tagaaa";
    my @stuff;
    for my $tag (@tags) {
        if (!$tag) { return }
        push @stuff, { tag => $tag, id => $tag->id, counter => $counter++ };
    }
    my $sql = "select photo.id as id, photo.title as title, uploader, uploaded, x, y
from photo, ". (join ",", map{ "tagging ".$_->{counter} } @stuff).
" where ". (join " AND ", map { "$_->{counter}.tag=$_->{id} and photo.id
= $_->{counter}.photo" } @stuff);

$sql .= " order by photo.uploaded desc";
    my $sth = $self->db_Main->prepare($sql);
}

sub list :Exported {
    my ($self, $r) = @_;
    my $page = $r->params->{page} || 1;
    my $pager = Memories::Tagging->pager(
        Memories->config->{photos_per_page}, $page
    );
    $r->{template_args}{pager} = $pager;
    $r->objects([map {$_->tag} $pager->search_all]);
}

sub list_js :Exported {
    my ($self, $r) = @_;
    $r->objects([ $self->retrieve_all ]);
}

package Memories::Tagging;
use base qw(Memories::DBI);
use Class::DBI::Pager;
__PACKAGE__->columns(TEMP => qw/count/);
__PACKAGE__->columns(Essential => qw/id tag photo/);
__PACKAGE__->set_sql(summary => qq/
SELECT  id, tag, count(*) AS count
FROM tagging
GROUP BY tag
ORDER BY count DESC
LIMIT 75
    /);
__PACKAGE__->set_sql(all => qq/
SELECT  id, tag, count(*) AS count
FROM tagging
GROUP BY tag
ORDER BY count DESC
    /);
Memories::Tagging->has_a("photo" => "Memories::Photo");
Memories::Tagging->has_a("tag" => "Memories::Tag");

Memories::Photo->has_many(tags => ["Memories::Tagging" => "tag"]);
Memories::Photo->has_many(taggings => "Memories::Tagging");
Memories::Tag->has_many(photos => ["Memories::Tagging" => "photo"] );
Memories::Tag->has_many(taggings => "Memories::Tagging");

1;
