/*
 *  Merlin's Clock Applet
 *  - A GNOME panel applet that displays the time or date.
 *  Copyright (C) 1999 Merlin Hughes
 *  - merlin@merlin.org
 *  - http://nitric.com/freeware/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <time.h>
#include <gnome.h>
#include <gdk/gdkx.h>

#include <applet-widget.h>

#include "merlin-clock.h"
#include "session.h"

void
merlin_clock_session_load(gchar * cfgpath, MerlinClockData * mc)
{

  /* We specify that we want the properties for this applet ... */
  gnome_config_push_prefix (cfgpath);

  /* Global configurable parameters */
  mc->datemode = !strcmp (MERLIN_CLOCK_DATEMODE_DATE,
                          gnome_config_get_string_with_default
                          ("merlin-clock/mode=" MERLIN_CLOCK_DEFAULT_DATEMODE, NULL));

  mc->breadth = gnome_config_get_int_with_default
    ("merlin-clock/breadth=" MERLIN_CLOCK_DEFAULT_BREADTH, NULL);

  mc->extended = gnome_config_get_bool_with_default
    ("merlin-clock/extended=" MERLIN_CLOCK_DEFAULT_EXTENDED, NULL);

  strncpy(mc->foreground_s,
	  gnome_config_get_string_with_default
	  ("merlin-clock/foreground=" MERLIN_CLOCK_DEFAULT_FOREGROUND, NULL),
	  sizeof(mc->foreground_s));

  strncpy(mc->background_s,
	  gnome_config_get_string_with_default
	  ("merlin-clock/background=" MERLIN_CLOCK_DEFAULT_BACKGROUND, NULL),
	  sizeof(mc->background_s));

  mc->font_s = gnome_config_get_string_with_default
    ("merlin-clock/font=" MERLIN_CLOCK_DEFAULT_FONT, NULL);

  gnome_config_pop_prefix ();
} /* merlin_clock_session_load */

int
merlin_clock_session_save(GtkWidget * w,
		     const char * privcfgpath,
		     const char * globcfgpath,
		     gpointer data)
{
  MerlinClockData * mc = data;

  gnome_config_push_prefix (privcfgpath);

  /* Global configurable parameters */
  gnome_config_set_string ("merlin-clock/mode", mc->datemode ? MERLIN_CLOCK_DATEMODE_DATE : MERLIN_CLOCK_DATEMODE_TIME);
  gnome_config_set_int ("merlin-clock/breadth", mc->breadth);
  gnome_config_set_string ("merlin-clock/extended", mc->extended ? "true" : "false");
  gnome_config_set_string ("merlin-clock/foreground", mc->foreground_s); 
  gnome_config_set_string ("merlin-clock/background", mc->background_s);
  gnome_config_set_string ("merlin-clock/font", mc->font_s);

  gnome_config_pop_prefix ();

  gnome_config_sync ();
  gnome_config_drop_all ();

  return FALSE;
} /* merlin_clock_session_save */

void
merlin_clock_session_defaults(MerlinClockData * mc)
{
  /* Global configurable parameters */
  mc->datemode =  !strcmp (MERLIN_CLOCK_DEFAULT_DATEMODE, MERLIN_CLOCK_DATEMODE_DATE);
  mc->breadth = atoi (MERLIN_CLOCK_DEFAULT_BREADTH);
  mc->extended = !strcmp (MERLIN_CLOCK_DEFAULT_EXTENDED, "true");
  strncpy(mc->foreground_s, MERLIN_CLOCK_DEFAULT_FOREGROUND, sizeof(mc->foreground_s));
  strncpy(mc->background_s, MERLIN_CLOCK_DEFAULT_BACKGROUND, sizeof(mc->background_s));
  mc->font_s = MERLIN_CLOCK_DEFAULT_FONT;
} /* merlin_clock_session_defaults */
