/* getblock.c -- read a block of bytes from a DVI file.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>
#include "extern.h"


int
DEFUN (get_block, (buffer, count),
char *buffer AND
int count)
{
  int result;

  result = fread (buffer, 1, count, dvi_file);
  if (result != count)
    die ("%s:%s: Read error at position %d\n", prog_name, dvi_name, dvi_pos);

  dvi_pos += count;

  return (result);
}
