/*
 * Copyright (c) 2003-2005 Alexandre Ratchov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 * 	- Redistributions of source code must retain the above
 * 	  copyright notice, this list of conditions and the
 * 	  following disclaimer.
 *
 * 	- Redistributions in binary form must reproduce the above
 * 	  copyright notice, this list of conditions and the
 * 	  following disclaimer in the documentation and/or other
 * 	  materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MIDISH_SAVELOAD_H
#define MIDISH_SAVELOAD_H

struct textout_s;
struct ev_s;
struct track_s;
struct filt_s;
struct rule_s;
struct songchan_s;
struct songtrk_s;
struct songfilt_s;
struct songsx_s;
struct song_s;

void ev_output(struct ev_s *e, struct textout_s *f);
void track_output(struct track_s *t, struct textout_s *f);
void rule_output(struct rule_s *o, struct textout_s *f);
void filt_output(struct filt_s *o, struct textout_s *f);
void songtrk_output(struct songtrk_s *o, struct textout_s *f);
void songchan_output(struct songchan_s *o, struct textout_s *f);
void songfilt_output(struct songfilt_s *o, struct textout_s *f);
void songsx_output(struct songsx_s *o, struct textout_s *f);
void song_output(struct song_s *o, struct textout_s *f);


void track_save(struct track_s *o, char *name);
unsigned track_load(struct track_s *o, char *name);

void song_save(struct song_s *o, char *name);
unsigned song_load(struct song_s *o, char *filename);


#endif /* MIDISH_SAVELOAD_H */
