proc lassign {vars vals} {
    uplevel 1 [list foreach $vars $vals break]
}

proc lmatch_prefix {list str} {
    set matches [list]

    foreach el $list {
	if {[string first $str $el] == 0} {
	    lappend matches $el
	}
    }

    return $matches
}

proc lmatch {list glob} {
    if {$glob eq "*"} {
	return $list
    }

    set matches [list]

    foreach el $list {
	if {[string match $glob $el]} {
	    lappend matches $el
	}
    }

    return $matches
}

# remove an element from a list

proc lremove {listvar el} {
    upvar 1 $listvar list
    
    set i [lsearch -exact $list $el]

    if {$i != -1} {
	set list [lreplace $list $i $i]
    }
}

proc ltrimleft {list n} {
    set result [list]

    foreach el $list {
	lappend result [string range $el $n end]
    }

    return $result
}

# turn secs into human readable time description

proc duration {secs} {
    set res ""

    foreach div {86400 3600 60} mod {0 24 60} name {day hour minute} {
        set n [expr {$secs / $div}]

        if {$mod > 0} {
	    set n [expr {$n % $mod}]
	}

        if {$n > 1} {
            append res $n " " $name "s "
	} elseif {$n == 1} {
            append res $n " " $name " "
	}
    }

    return $res
}
