C
      DOUBLE PRECISION FUNCTION XMNGPI(XMPP,ALPH,XMG,XWG,XMP
     1 ,XMUP,XMU)
C
C  THIS FUNCTION GENERATES THE FIT  TO THE UPS --> PI PI MASS
C       DISTRIBUTION GIVEN IN FIG. 25 OF M. PESKIN'S 1983 SLAC
C          SUMMER SCHOOL NOTES
C   THE OVERALL NORMALIZATION OF THE CURVE IS ARBITRARY
C
C   XMPP IS THE PI-PI INVARIANT MASS, IN MEV
C   ALPH IS THE PARAMETER IN PESKIN'S EQ. 4.37
C   XMG, XWG ARE THE MASS AND WIDTH (IN MEV) ASSUMED FOR THE FICTITIOUS
C       GLUONIUM RESONANCES IN PESKIN'S MODEL
C   THE CURVES IN THE SUMMER SCHOOL LECTURES USE:
C       ALPH = -2,  XMG = XWG = 600.
C
C FIRST, SET SOME PARAMETERS.  XMP IS THE PION MASS,  XMUP IS THE
C  HIGHER UPSILON  MASS (UPS PRIME OR DOUBLE PRIME),
C          XMU IS THE UPSILON MAS
C  THIS FUNCTION GENERATES THE FIT  TO THE UPS --> PI PI MASS
C       DISTRIBUTION GIVEN IN FIG. 25 OF M. PESKIN'S 1983 SLAC
C          SUMMER SCHOOL NOTES
C   THE OVERALL NORMALIZATION OF THE CURVE IS ARBITRARY
      DOUBLE PRECISION QZ,QZERO,QQ,QK,QP,A,B,DEN,AAC,ABC,BBC
      DOUBLE PRECISION XMPP,ALPH,XMG,XWG,XMP,XMUP,XMU,XMPS,XMS
      XMPS = XMP**2
C
C  THE UPSILON PRIME IS AT 10020, THE UPSILON DOUBLE PRIME AT 10350
C  NOW COMPUTE THE BASIC KINEMATIC QUANTITIES
      XMS = XMPP**2
      QZ = (XMS + (XMUP-XMU)*(XMUP+XMU))/(2.0*XMUP)
      QZERO = QZ/XMPP
      QQ =SQRT(((XMUP-XMU)**2-XMS)*((XMUP+XMU)**2-XMS))/(2.0 * XMUP)
      QK = (XMS - 2.0*XMPS)
      QP = (XMS - 4.0 * XMPS)
C COMPUTE THE PARAMETERS A AND B IN THE MATRIX ELEMENT:
C
C        M  =  A  Q1*Q2  +  B Q10*Q20
C
      A = -((2.0)/9.0)*(QQ/XMG)**4
      B =(1.0 -(QZ/XMG)**2)+ (QQ/XMG)**2/(3.0)
     *      + (2.0)*(QQ*QZ/XMG**2)**2/(3.0)
     *      + (2.0)*(QQ/XMG)**4/(9.0)
      A = A + (3.0)*ALPH
      DEN = SQRT((XMS-XMG**2)**2 + (XMG*XWG)**2)
      A=A/DEN
      B=B/DEN
C FINALLY, PLUG INTO YAN'S FORMULA FOR THE D N / D XMPP:
      AAC = (A**2)*(QK**2)
      ABC = (A*B)*(QK)
     *  *(QP + QZERO**2 *(2.0)*(XMS + 2.0*XMPS))/(3.0)
CGJB  BBC = (0.5)*(B**2)*(3.0*(QP**2) +
CGJB *     4.0*(QZERO**2)*QP*(XMS + 6.0*XMPS)  +
CGJB *     8.0*(QZERO**4)*(XMS**2 + 2.0*XMS*XMPS + 6.0*XMPS**2))
      BBC = (1.0/60.)*(B**2)*(3.0*(QP**2) +
     *     4.0*(QZERO**2)*QP*(XMS + 6.0*XMPS)  +
     *     8.0*(QZERO**4)*(XMS**2 + 2.0*XMS*XMPS + 6.0*XMPS**2))
      XMNGPI  = QQ*SQRT(QP)*(AAC + ABC  + BBC)
      RETURN
      END
