      SUBROUTINE MIN_CONT(FCN,NNUM,RNUMB,FUTIL)
C
C-----------------------------------------------------------------------
C
C     Gets the MINOS type contour and makes a plot of it
C
C     Called by MIN_CMD
C
C-----------------------------------------------------------------------
C
      EXTERNAL FCN,FUTIL
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnhpj.inc"
#include "mnscr.inc"
C
      INTEGER NNUM
      DOUBLE PRECISION RNUMB(*)
C
      INTEGER MAXPT
      PARAMETER (MAXPT = 500)
      DOUBLE PRECISION XPT(MAXPT),YPT(MAXPT)
      REAL SXPT(MAXPT),SYPT(MAXPT)
C
      EQUIVALENCE(SCRATCH(1),XPT)
      EQUIVALENCE(SCRATCH(2*MAXPT+1),YPT)
      EQUIVALENCE(SCRATCH(4*MAXPT+1),SXPT)
      EQUIVALENCE(SCRATCH(6*MAXPT+1),SYPT)
C
      DOUBLE PRECISION VAL,ERROR,BND1,BND2
      INTEGER IVARBL
C
      CHARACTER*80 TITLE
      INTEGER IDBIN(2)
      REAL ADLO(2),ADHI(2)
      REAL ACONT(3*3)
      CHARACTER*32 TNAME(2)
C
      IF(NNUM.LT.2) THEN
          CALL MN_ERR('MIN_CONT'
     +     ,'You must give the parameter numbers to plot')
          GOTO 9000
      ENDIF
C
      IP1 = NINT(RNUMB(1))
      IP2 = NINT(RNUMB(2))
      IF(NNUM.GT.2) THEN
          NPTS = MAX0(4,MIN0(MAXPT,NINT(RNUMB(3))))
      ELSE
          NPTS = 40
      ENDIF
C
      CALL MNCONT(FCN,IP1,IP2,NPTS,XPT,YPT,NFOUND,FUTIL)
      IF(NFOUND.EQ.0) NFOUND = NPTS
C
      IF(NFOUND.LE.0) THEN
          CALL MN_ERR('MIN_CONT','Error calculating the contour')
          GOTO 9000
      ENDIF
C
C     Put the result in a plot
C
      CALL MNPOUT(IP1,TNAME(1),VAL,ERROR,BND1,BND2,IVARBL)
      CALL MNPOUT(IP2,TNAME(2),VAL,ERROR,BND1,BND2,IVARBL)
      LEN1 = LENOCC(TNAME(1))
      LEN2 = LENOCC(TNAME(2))
      TITLE = 'Contour of ' // TNAME(2)(1:LEN2) // ' vs ' //
     + TNAME(1)(1:LEN1)
C
      IDAF   = 98765
      IDBF   = 999
      NDIM   = -2
      NWPPT  = 2
      NPNT   = NFOUND + 1
      NWRD   = NPNT * NWPPT
      NBPPT  = 0
      NTMOD2 = 0
      CALL MN_HNW(IDAF,IDBF,NDIM,NWRD,NH,NPTRH,NPTRD,NWH,NBPPT,NTMOD2)
C
      IDBIN(1) = 0
      IDBIN(2) = 0
      ADLO(1) = 1.0E+31
      ADHI(1) = -1.0E+31
      ADLO(2) = 1.0E+31
      ADHI(2) = -1.0E+31
C      EDLO = 1.0E+31
C      EDHI = -1.0E+31
      NPTR = NPTRD - NWPPT
      DO 2000 I=1,NFOUND
          SXPT(I) = SNGL(XPT(I))
          SYPT(I) = SNGL(YPT(I))
          ADLO(1) = AMIN1(ADLO(1),SXPT(I))
          ADHI(1) = AMAX1(ADHI(1),SXPT(I))
          ADLO(2) = AMIN1(ADLO(2),SYPT(I))
          ADHI(2) = AMAX1(ADHI(2),SYPT(I))
C          EDLO = AMIN1(EDLO,SYPT(I))
C          EDHI = AMAX1(EDHI,SYPT(I))
C
          NPTR = NPTR + NWPPT
          RDAT(NPTR + 0) = SXPT(I)
          RDAT(NPTR + 1) = SYPT(I)
2000  CONTINUE
      NPTR = NPTR + NWPPT
      RDAT(NPTR + 0) = SXPT(1)
      RDAT(NPTR + 1) = SYPT(1)
C
      DEL1 = ADHI(1) - ADLO(1)
      ADLO(1) = ADLO(1) - 0.10*DEL1
      ADHI(1) = ADHI(1) + 0.10*DEL1
      DEL2 = ADHI(2) - ADLO(2)
      ADLO(2) = ADLO(2) - 0.10*DEL2
      ADHI(2) = ADHI(2) + 0.10*DEL2
      EDENT = FLOAT(NPNT)
      EDLO = 0.0
      EDHI = 1.0
      NWTOT = NWH + NWRD
      CALL M_RTIM(NHDAT2,NHTIM2)
      NSDAT2 = 0
      NSTIM2 = 0
      CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWRD,IDAF,IDBF,NDIM,NWPPT,NPNT
     1 ,NHDAT2,NHTIM2,NSDAT2,NSTIM2,NTMOD2
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
      CALL MN_PTU(NH,NWTOT,IDAF,IDBF,NPTRH,NPTRD,TITLE
     1 ,'Generated internally',' ',TNAME)
      CALL MN_MSU(IDAF,IDBF,NDIM,NWH,NH)
C
      IF(QDFIT) CALL MN_FRP
      QLEGO = .FALSE.
      QDFUN = .FALSE.
C
      NHPLT = 1
      IPLTIA(NHPLT) = IDAF
      IPLTIB(NHPLT) = IDBF
      IPLTSY(NHPLT) = -1
      IPLTHA(NHPLT) = 0
      IPLTPA(NHPLT) = 0
      IPLTCO(1,NHPLT) = ICOLS(7)
      IPLTCO(2,NHPLT) = ICOLS(8)
      IPLTCO(3,NHPLT) = ICOLS(9)
      IPLTFL(NHPLT) = 1
      IPLTCL(NHPLT) = 1
      IPLTLG(NHPLT) = 0
      NPLTCM(NHPLT) = 0
      NPLTKY(NHPLT) = 0
C
      CALL MN_DRW(1,NDERR)
C
9000  CONTINUE
      END
