      SUBROUTINE MN_HDR(RBUF,NDIM,NWPPT,NPNT
     + ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     1 ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,AMEAN,ASIG)
C
C     UNPACKS THE HISTOGRAM HEADER
C     WORD  1 TOTAL NUMBER OF WORDS
C           2 NUMBER OF WORDS IN THE HEADER
C           3 NUMBER OF DATA WORDS
C           4 PRIMARY IDENTIFIER
C           5 SECONDARY IDENTIFIER
C           6 NUMBER OF DIMENSIONS
C           7 NUMBER OF WORDS PER POINT
C           8 NUMBER OF POINTS
C           9 NUMBER OF CALLS
C          10 MINIMUM NUMBER OF ENTRIES (INCLUDING WEIGHT)
C          11 MAXIMUM NUMBER OF ENTRIES (INCLUDING WEIGHT)
C          12 NUMBER OF BINS FOR FIRST VARIABLE
C          13 LOWER LIMIT FOR FIRST VARIABLE
C          14 UPPER LIMIT FOR FIRST VARIABLE
C          15 NUMBER OF BINS FOR SECOND VARIABLE
C          16 LOWER LIMIT FOR SECOND VARIABLE
C          17 UPPER LIMIT FOR SECOND VARIABLE
C          12 + 3*NDIM NUMBER OF BITS PER POINT
C          13 + 3*NDIM NUMBER OF UNDERFLOWS
C          14 + 3*NDIM NUMBER INSIDE LIMITS
C          15 + 3*NDIM NUMBER OF OVERFLOWS
C          16 + 3*NDIM ...
C          12 + 3*NDIM + 3**NDIM + 1 MEAN FOR FIRST VARIABLE
C          12 + 3*NDIM + 3**NDIM + 2 SIGMA FOR FIRST VARIABLE
C          12 + 3*NDIM + 3**NDIM + 1 MEAN FOR SECOND VARIABLE
C          12 + 3*NDIM + 3**NDIM + 2 SIGMA FOR SECOND VARIABLE
C          12 + 3*NDIM + 3**NDIM + 2*NDIM + 1 DATE
C          12 + 3*NDIM + 3**NDIM + 2*NDIM + 2 TIME
C          12 + 3*NDIM + 3**NDIM + 2*NDIM + 3 Starting date for time plots
C          12 + 3*NDIM + 3**NDIM + 2*NDIM + 4 Starting time for time plots
C          12 + 3*NDIM + 3**NDIM + 2*NDIM + 5 Time mode
C
      REAL RBUF(*)
      INTEGER IDBIN(*)
      REAL ADLO(*),ADHI(*),AMEAN(*),ASIG(*)
C
      NWH   = NINT(RBUF(2))
      NDIM  = NINT(RBUF(6))
      NWPPT = NINT(RBUF(7))
      NPNT  = NINT(RBUF(8))
      EDENT = RBUF(9)
      EDLO  = RBUF(10)
      EDHI  = RBUF(11)
      DO 1000 II=1,IABS(NDIM)
          IDBIN(II) = NINT(RBUF(3*(II-1)+12))
          ADLO(II)  = RBUF(3*(II-1)+13)
          ADHI(II)  = RBUF(3*(II-1)+14)
1000  CONTINUE
C
C     Get the number of bits per point
C
      NN = 11 + 3*IABS(NDIM) + 1
      IF(NN.LE.NWH) THEN
          NBPPT = NINT(RBUF(NN))
      ELSE
          IF(NDIM.GT.2) THEN
              NBPPT = 16
          ELSE
              NBPPT = 32
          ENDIF
      ENDIF
C
C     Skip the number of underflows and overflows and get
C     the means and sigmas
C
      NN = 13 + 3*IABS(NDIM)
      IF(ndim.gt.-3 .and. ndim.le.3)
     + NN = NN + 3**IABS(NDIM)
*
*     For dimension -1 histograms see if the underflows and overflows
*     are really stored.
*
      IF(NDIM.EQ.-1) THEN
          IF(NWH.EQ.15       .OR.
     +       NWH.EQ.15+2     .OR.
     +       NWH.EQ.15+2+2  ) THEN
*ICB     +       NWH.EQ.15+2+2+3) THEN
              NN = NN - 3**IABS(NDIM)
          ENDIF
      ENDIF
*
      IF(NN.LT.NWH .AND. NDIM.GT.-3) THEN
          DO 2000 II=1,IABS(NDIM)
              AMEAN(II) = RBUF(NN+2*(II-1))
              ASIG(II)  = RBUF(NN+2*(II-1)+1)
2000      CONTINUE
          NN = NN + 2*IABS(NDIM)
      ELSE
          CALL VFILL(AMEAN,IABS(NDIM),-1.0)
          CALL VFILL(ASIG,IABS(NDIM),-1.0)
      ENDIF
C
C     Get the date and time
C
      IF(NN.LT.NWH) THEN
          NHDATE = NINT(RBUF(NN))
          NHTIME = NINT(RBUF(NN+1))
      ELSE
          NHDATE = 0
          NHTIME = 0
      ENDIF
C
C     Get the starting date/time and mode for time plots
C
      NN = NN + 2
      IF(NN.LT.NWH) THEN
          NSDATE = NINT(RBUF(NN))
          NSTIME = NINT(RBUF(NN+1))
          NTMODE = NINT(RBUF(NN+2))
      ELSE
          NSDATE = 0
          NSTIME = 0
          NTMODE = 0
      ENDIF
C
      RETURN
      END
