      subroutine m_chkv(idh,ierr)
*
*-----------------------------------------------------------------------
*
*     Checks if there are any extra variables to be gotten from a CWN
*     e.g. if I want to get a variable dimensioned array element.
*     Adds the weight variables, if any.
*     Also add any extra variables defined with SET NTUPLE VARIABLE.
*     Store the location of the variables and sort them into the right order
*
*     Called by mn_prj
*
*-----------------------------------------------------------------------
*
      implicit none
*
#include "mnpar.inc"
#include "mnprj.inc"
#include "mncwn.inc"
#include "mninf.inc"
#include "mncut.inc"
#include "mnprs.inc"
#include "mndbg.inc"
#include "mnlun.inc"
*
      integer idh,ierr
*
      integer i,k,nsub,itype,isize,ielem,nwr4,nwr8,nwch,ipos
      integer ioerr,nv,nvar,nval,lenc,lenb,lnblnk
      integer nn,nc
      integer j,nvcwno
*
*     HBOOK fix - temporary arrays!
*
      integer indsrt(mdimmx)
*
      character chtag*32,block*8,tvar1*32,tvar2*32,comand*8
      logical  hntnew,qcwntp
      external hntnew
*
      ierr = 0
*
      qcwntp = hntnew(idh)
      if(.not.qcwntp) then
          write(txterr,'('' Ntuple'',I8,'' is not a CWN'')'
     +     ,iostat=ioerr) idh
          call mn_err('M_CHKV',txterr)
          ierr = 1
          goto 9000
      endif
*
      if(nvcwn.eq.0) then
          txtmes = ' All CWN variables will be fetched'
          call mn_mes(luntto,'ME',txtmes)
          return
      endif
*
*     Get the variables that are indices
*
      nvcwno = nvcwn
      do i=1,nvcwno
          nvar = ivcwn(i)
          nsub = ivsub(1,nvar)
          do j=1,nsub
              if(ivsub(2+j,nvar).lt.0) then
                  nv = -ivsub(2+j,nvar)
*
*                 Check if I have this variable already
*
                  do k=1,nvcwn
                      if(ivcwn(k).eq.nv) goto 1100
                  enddo
*
                  call hntvar(idh,nv,chtag,block
     +             ,nsub,itype,isize,ielem)
                  lenc = lnblnk(chtag)
                  lenb = lnblnk(block)
*
                  if(qdebug)
     +             write(6,'('' Ind1 idh:'',I8,'' tag,block:'',2(1x,a)
     +             ,'' sub,type,size,elem'',i2,3i4)')
     +             idh,chtag,block,nsub,itype,isize,ielem
*
                  nvcwn = nvcwn + 1
                  ivcwn(nvcwn)   = nv
                  iecwn(1,nvcwn) = 1
                  iecwn(2,nvcwn) = 0
*
                  call m_hbnam(idh,nv,nvcwn)
 1100             continue
              endif
          enddo
      enddo
*
*     Loop over the cuts to see if there are any variables to get
*
      do nn=1,ncuse
          nc   = icuse(nn)
          nvar = icvar(1,nc)
          nval = icval(1,nc)
*
*         Non-COMIS cut - get variable name(s)
*
          if(ictype(nc).ge.1 .and. ictype(nc).le.3) then
              if(nvar.gt.0) then
*
*                 Check if I have this variable/element already
*
                  do k=1,nvcwn
                      if(ivcwn(k).eq.nvar) then
                          goto 3100
                      endif
                  enddo
*
                  call hntvar(idh,nvar,chtag,block
     +             ,nsub,itype,isize,ielem)
                  if(qdebug)
     +             write(6,'('' Cut2 idh:'',I8,'' tag,block:'',2(1x,a)
     +             ,'' sub,type,size,elem'',i2,3i4)')
     +             idh,chtag,block,nsub,itype,isize,ielem
                  lenc = lnblnk(chtag)
                  lenb = lnblnk(block)
*
                  nvcwn = nvcwn + 1
                  ivcwn(nvcwn) = nvar
                  call ucopy_i(icvar(2,nc),iecwn(1,nvcwn),9)
*
                  call m_hbnam(idh,nvar,nvcwn)
 3100             continue
*
*                 Look for variables inside the cut
*
                  do j=1,icvar(3,nc)
                      if(icvar(3+j,nc).lt.0) then
                          nv = -icvar(3+j,nc)
*
*                         Check if I have this variable already
*
                          do k=1,nvcwn
                              if(ivcwn(k).eq.nv) goto 3200
                          enddo
*
                          call hntvar(idh,nv,chtag,block
     +                     ,nsub,itype,isize,ielem)
                          lenc = lnblnk(chtag)
                          lenb = lnblnk(block)
*
                          if(qdebug)
     +                     write(6,'('' Add2 idh:'',I8
     +                     ,'' tag,block:'',2(1x,a)
     +                     ,'' sub,type,size,elem'',i2,3i4)') idh
     +                     ,chtag,block
     +                     ,nsub,itype,isize,ielem
*
                          nvcwn = nvcwn + 1
                          ivcwn(nvcwn)   = nv
                          iecwn(1,nvcwn) = 1
                          iecwn(2,nvcwn) = 0
*
                          call m_hbnam(idh,nv,nvcwn)
 3200                     continue
                      endif
                  enddo
*
*             Cut is an expression
*
              elseif(nvar.lt.0) then
                nv = -icvar(1,nc)
                nsub = lcexpr(nv)
                do 3300 ipos=1,nsub
                  if(icetyp(ipos,nv).gt.0) then
                    comand = clcnam(icetyp(ipos,nv))
                    if(comand.eq.'X') then
                      nvar = icetv(1,ipos,nv)
                      do k=1,nvcwn
                        if(ivcwn(k).eq.nvar) goto 3300
                      enddo
*
                      nvcwn = nvcwn + 1
                      ivcwn(nvcwn) = nvar
                      call ucopy_i(icetv(2,ipos,nv),iecwn(1,nvcwn)
     +                 ,9)
                      call m_hbnam(idh,nvar,nvcwn)
                    endif
                  endif
 3300           continue
              endif
          endif
*
*         Value is also an expression
*
          if(ictype(nc).eq.3) then
              if(nval.gt.0) then
*
*                 Check if I have this variable/element already
*
                  do k=1,nvcwn
                      if(ivcwn(k).eq.nval) then
                          goto 3400
                      endif
                  enddo
*
                  call hntvar(idh,nval,chtag,block
     +             ,nsub,itype,isize,ielem)
                  if(qdebug)
     +             write(6,'('' Cut3 idh:'',I8,'' tag,block:'',2(1x,a)
     +             ,'' sub,type,size,elem'',i2,3i4)')
     +             idh,chtag,block,nsub,itype,isize,ielem
                  lenc = lnblnk(chtag)
                  lenb = lnblnk(block)
*
                  nvcwn = nvcwn + 1
                  ivcwn(nvcwn) = nval
                  call ucopy_i(icval(2,nc),iecwn(1,nvcwn),9)
*
                  call m_hbnam(idh,nval,nvcwn)
 3400             continue
*
*                 Look for variables inside the cut
*
                  do j=1,icval(3,nc)
                      if(icval(3+j,nc).lt.0) then
                          nv = -icval(3+j,nc)
*
*                         Check if I have this variable already
*
                          do k=1,nvcwn
                              if(ivcwn(k).eq.nv) goto 3500
                          enddo
*
                          call hntvar(idh,nv,chtag,block
     +                     ,nsub,itype,isize,ielem)
                          lenc = lnblnk(chtag)
                          lenb = lnblnk(block)
*
                          if(qdebug)
     +                     write(6,'('' Add3 idh:'',I8
     +                     ,'' tag,block:'',2(1x,a)
     +                     ,'' sub,type,size,elem'',i2,3i4)') idh
     +                     ,chtag,block
     +                     ,nsub,itype,isize,ielem
*
                          nvcwn = nvcwn + 1
                          ivcwn(nvcwn)   = nv
                          iecwn(1,nvcwn) = 1
                          iecwn(2,nvcwn) = 0
*
                          call m_hbnam(idh,nv,nvcwn)
 3500                     continue
                      endif
                  enddo
*
*             Cut is an expression
*
              elseif(nval.lt.0) then
                nv   = -icval(1,nc)
                nsub = lcexpr(nv)
                do 3600 ipos=1,nsub
                  if(icetyp(ipos,nv).gt.0) then
                    comand = clcnam(icetyp(ipos,nv))
                    if(comand.eq.'X') then
                      nvar = icetv(1,ipos,nv)
                      do k=1,nvcwn
                        if(ivcwn(k).eq.nvar) goto 3600
                      enddo
*
                      nvcwn = nvcwn + 1
                      ivcwn(nvcwn) = nvar
                      call ucopy_i(icetv(2,ipos,nv),iecwn(1,nvcwn)
     +                 ,9)
                      call m_hbnam(idh,nvar,nvcwn)
                    endif
                  endif
 3600           continue
              endif
          endif
      enddo
*
*     Extra variables - maybe in a COMIS cut function
*
      do i=1,ncwn_x
          tvar1 = tcwn_x(i)
          call cltou(tvar1)
*
*         Check if I have this variable/element already
*
          do k=1,nvcwn
              tvar2 = chcwn(k)
              call cltou(tvar2)
              if(tvar1.eq.tvar2) then
                  goto 4200
              endif
          enddo
*
*         Find out which variable it is
*
          do k=1,iabs(ndim)
              call hntvar(idh,k,chtag,block
     +         ,nsub,itype,isize,ielem)
              tvar2 = chtag
              call cltou(tvar2)
              if(tvar1.eq.tvar2) then
                  nvar = k
                  goto 4100
              endif
          enddo
          write(txterr,'(''CWN id:'',I8
     +     ,'' Unknown variable: '',a)') idh,tcwn_x(i)
          ierr = 1
          goto 9000
*
 4100     continue
          if(qdebug)
     +     write(6,'('' Ext4 idh:'',I8,'' tag,block:'',2(1x,a)
     +     ,'' sub,type,size,elem'',i2,3i4)')
     +     idh,chtag,block,nsub,itype,isize,ielem
          lenc = lnblnk(chtag)
          lenb = lnblnk(block)
*
          nvcwn = nvcwn + 1
          chcwn(nvcwn)   = chtag(:lenc)
          chblk(nvcwn)   = block(:lenb)
          ivcwn(nvcwn)   = nvar
          iecwn(1,nvcwn) = 1
          iecwn(2,nvcwn) = 0
*
          call m_hbnam(idh,nvar,nvcwn)
 4200     continue
      enddo
*
*     Add the weight and its error if they are also given
*
*ICB      do i=1,nwexpr
*ICB          nv   = i
*ICB          nsub = lwexpr(nv)
*ICB          do 5300 ipos=1,nsub
*ICB              if(iwetyp(ipos,nv).gt.0) then
*ICB                  comand = clcnam(iwetyp(ipos,nv))
*ICB                  if(comand.eq.'X') then
*ICB                      nvar = iwetv(1,ipos,nv)
*ICB                      do k=1,nvcwn
*ICB                          if(ivcwn(k).eq.nvar) goto 5300
*ICB                      enddo
*ICB*
*ICB                      nvcwn = nvcwn + 1
*ICB                      ivcwn(nvcwn) = nvar
*ICB                      call ucopy_r(iwetv(2,ipos,nv),iecwn(1,nvcwn)
*ICB     +                 ,9)
*ICB                      call m_hbnam(idh,nvar,nvcwn)
*ICB                  endif
*ICB              endif
*ICB 5300     continue
*ICB      enddo
*
*     Loop over the variables needed and see if any are variable length
*     arrays.
*     This is necessary, but only get variables without subscripts!
*     No longer necessary??
*
      nvcwno = nvcwn
      do i=1,nvcwno
          nvar = ivcwn(i)
*
*         Get any higher level variables in the same block
*
          if(ivsub(1,nvar).gt.0) then
              do j=1,iabs(ndim)
*
*                 Check if I have this variable already
*
                  do k=1,nvcwn
                      if(ivcwn(k).eq.j) goto 6100
                  enddo
*
                  call hntvar(idh,j,chtag,block
     +             ,nsub,itype,isize,ielem)
                  lenc = lnblnk(chtag)
                  lenb = lnblnk(block)
*
*                 Variable must be in same block
*
                  if(chblk(i).ne.block) goto 6100
*
*                 Variable cannot be an array
*                 Variable must also be an integer
*
*ICB                  if(nsub.ge.ivsub(1,nvar)) goto 6100
                  if(nsub.gt.0)  goto 6100
                  if(itype.ne.2) goto 6100
*
                  if(qdebug)
     +             write(6,'('' Ind6 idh:'',I8,'' tag,block:'',2(1x,a)
     +             ,'' sub,type,size,elem'',i2,3i4)')
     +             idh,chtag,block,nsub,itype,isize,ielem
*
                  nvcwn = nvcwn + 1
                  ivcwn(nvcwn)   = j
                  iecwn(1,nvcwn) = 1
                  iecwn(2,nvcwn) = 0
*
                  call m_hbnam(idh,j,nvcwn)
 6100             continue
              enddo
          endif
      enddo
*
*     Cope with HBOOK problem - sort all variables into order for HBNAME
*
      call sortzv(ivcwn,indsrt,nvcwn,-1,0,0)
*
      call hbname(idh,' ',0,'$CLEAR')
*
      txtmes = ' The following CWN variables will be fetched:'
      call mn_mes(luntto,'M',txtmes)
      do i=1,nvcwn
          nvar  = ivcwn(indsrt(i))
          chtag = chcwn(indsrt(i))
          block = chblk(indsrt(i))
          itype = ivtype(nvar)
          isize = ivsize(nvar)
          ielem = ivelem(nvar)
*
          lenc = lnblnk(chtag)
          lenb = lnblnk(block)
*
          chcwnv(i) = chtag(:lenc)
*
          if((itype.eq.1 .and. isize.eq.4) .or.
     +     itype.eq.2 .or. itype.eq.3    .or. itype.eq.4) then
              nwr4  = ivposn(nvar)
              call hbname(idh,block(:lenb),ar4(nwr4)
     +         ,'$SET:'//chtag(:lenc))
          elseif(itype.eq.1 .and. isize.eq.8) then
              nwr8  = ivposn(nvar)
              call hbname(idh,block(:lenb),zr8(nwr8)
     +         ,'$SET:'//chtag(:lenc))
          else
              nwch  = ivposn(nvar)
              call hbnamc(idh,block(:lenb),cch(nwch)
     +         ,'$SET:'//chtag(:lenc))
          endif
          write(txtmes,'(2x,a,'':'',t28,''Block: '',a,t44
     +     ,'', Type:'',i2,'', Elements:'',i4,'', Size:'',i4)'
     +     ,iostat=ioerr)
     +     chtag(:lenc),block(:lenb),itype,ielem,isize
          call mn_mes(luntto,'M',txtmes)
      enddo
      call mn_mes(luntto,'E',' ')
*
 9000 continue
      END
