      SUBROUTINE M_IFPRS(IERR)
C
C-----------------------------------------------------------------------
C
C     Parses the expression for an IF or ELSEIF statement
C
C     Called by:   MN_CMD
C
C-----------------------------------------------------------------------
C
      implicit none
*
#include "mnpar.inc"
#include "mncmd.inc"
#include "mnprs.inc"
#include "mntyq.inc"
#include "mnlun.inc"
C
      INTEGER IERR, I, IST1, NCH1, ICOND, ICLOCL
      INTEGER LENT, LENR, LENL, leng, idelim, n1, npar, njnk
     + , ncond, niflv
      real val1, val2
      CHARACTER*80 TXT1, TXT2
      LOGICAL  COND(5), QTAG(5), qpass
C
      integer istrnq,icmtyq,lchtyp,lnblnk
      real    am_exp
      logical qmncon
      EXTERNAL istrnq,icmtyq,lchtyp,qmncon,am_exp
C
C     Initializations
C
      if(comnd1.eq.'IF') then
        IIFLV(NTDEP) = IIFLV(NTDEP) + 1
        IF(IIFLV(NTDEP) .GT. MXIFLV) THEN
          IERR = 5
          GOTO 9000
        ENDIF
      endif
*
      IERR = 0
      ICOND = 0

1500  CONTINUE
      IF(ICOND .GT. 0) THEN
C      Check for TAG if there are more conditions.
         IF(TXT2(1:1).EQ.'&') THEN
             QTAG(ICOND+1) = .TRUE.
         ELSEIF(TXT2(1:1).EQ.'|') THEN
             QTAG(ICOND+1) = .FALSE.
         ELSEIF(TXT2(1:1).NE.'.') THEN
             IST1 = ICMTYQ( .TRUE., IDELIM, ANDNAM )
             IF(LCHTYP().NE.ICHAR('.')) THEN
                CALL MN_ERR('M_IFPRS','Error in AND or OR.')
                IERR = 3
                GOTO 9000
C     Set QTAG true for .AND.s and false for .OR.s.
             ELSEIF(IST1 .EQ. 1) THEN
                QTAG(ICOND+1) = .TRUE.
             ELSEIF(IST1 .EQ. 2) THEN
                QTAG(ICOND+1) = .FALSE.
             ELSE
                CALL MN_ERR('M_IFPRS','Error linking conditionals')
                IERR = 4
                GOTO 9000
             ENDIF
         ELSE
C     Assume that anything leftover is commentary - hope for the best.
             GOTO 5000
         ENDIF
      ENDIF

      TXT1 = ' '
      IST1 = ISTRNQ(.TRUE.,TXT1,NCH1)
      IF(NCH1.LE.0) GOTO 9000
      CALL CLTOU(TXT1)
      ICOND = ICOND + 1

C     Look for surrounding parentheses and strip them.
C     Or for leftover .s from .AND. or .OR. or & or |. and strip Them.

      N1 = 1
      LENT = LNBLNK(TXT1)
      LENR = 0
      LENL = 0
      IF(TXT1(1:1).EQ.'.' .OR.
     +   TXT1(1:1).EQ.'&'.OR.TXT1(1:1).EQ.'|') N1 = 2
      IF(TXT1(1:1).EQ.'(') THEN
          N1=2
          NPAR = 0
          DO 1000 I = 1, NCH1
              IF(TXT1(I:I).EQ.'(') NPAR = NPAR + 1
              IF(TXT1(I:I).EQ.')') NPAR = NPAR - 1
              IF(NPAR .EQ. 0) THEN
                  LENL = I - 1
                  LENR = I + 1
                  GOTO 1010
              ELSEIF(NPAR.LT.0) THEN
                  TXTERR = 'Parentheses are not balanced: ' //
     +             TXT1(1:I)
                  CALL MN_ERR('M_IFPRS',TXTERR)
                  IERR = 1
                  GOTO 9000
              ENDIF
 1000     CONTINUE
          IF(NPAR.NE.0) THEN
              TXTERR = 'Parentheses are not balanced: ' //
     +         TXT1(1:NCH1)
              CALL MN_ERR('M_IFPRS',TXTERR)
              IERR = 1
              GOTO 9000
          ENDIF
      ENDIF
 1010 CONTINUE
C
C     Put stripped expression + the rest into TYPSCN buffer.
C
      if(lenr.gt.0 .and. lenr.le.nch1) then
          txt2 = txt1(n1:lenl) // txt1(lenr:)
      elseif(lenl.gt.0) then
          txt2 = txt1(n1:lenl)
      else
          txt2 = txt1
      endif
      call cltou(txt2)
      lent = lnblnk(txt2)
      call quotyq(txt2(1:lent))
C
C     Parse off the left side of the first expression
C
      CALL M_EPRS(-1, NJNK, TXT1, IDELIM, IERR)
      IF(IERR .NE. 0) GOTO 9000
C
C     Hold TYPSCN buffer left over from M_EPRS in local, temp storage.
C
      IST1 = ISTRNQ(.TRUE.,TXT2,NCH1)
      IF(NCH1.LE.0) GOTO 9000
      CALL CLTOU(TXT2)
C
C     Put the left side of first expression back in to buffer and
*     evaluate.
C
      LENT = LNBLNK(TXT1)
*ICB      CALL QUOTYQ(TXT1(1:LENT))
*
      call m_prse(.false.,leng,txt1(:lent),istyp,istp,istf
     + ,istv,qpass)
      if(qpass) then
          val1 = am_exp(leng,istyp,istp,istf,istv)
      else
          TXTERR = 'Error evaluating left part of IF expression'
          CALL MN_ERR('M_IFPRS',TXTERR)
          ierr = 1
          goto 9000
      endif
*ICB       VAL1 = VALTYQ(.TRUE.,IDELIM)
*ICB       if((idelim.gt.0 .and. idelim.ne.ichar(')')) .or. nchscn().eq.0)
*ICB     +  goto 9000
C
C      Put TYPSCN buffer back and look for a conditional
C
      LENT = LNBLNK(TXT2)
      CALL QUOTYQ(TXT2(1:LENT))

      NCOND = 0
      CALL M_COND(NCOND, IDELIM, IERR)
      if(ierr.ne.0) goto 9000
C
C     Get the right side of the expression
C
      CALL M_EPRS(0,NJNK,TXT1,IDELIM,IERR)
      IF(IERR .NE. 0) GOTO 9000
C
C     Hold TYPSCN buffer left over from M_EPRS in local, temp storage.
C
      IF(IDELIM .EQ. 0) THEN
          IST1 = ISTRNQ(.TRUE.,TXT2,NCH1)
          IF(NCH1.LE.0) GOTO 9000
          CALL CLTOU(TXT2)
      ELSE
          TXT2 = ' '
      ENDIF
C
C     Put the right side of first expression back in to buffer and
*     evaluate.
C
      LENT = LNBLNK(TXT1)
*ICB      CALL QUOTYQ(TXT1(1:LENT))
*
      call m_prse(.false.,leng,txt1(:lent),istyp,istp,istf
     + ,istv,qpass)
      if(qpass) then
          val2 = am_exp(leng,istyp,istp,istf,istv)
      else
          TXTERR = 'Error evaluating right part of IF expression'
          CALL MN_ERR('M_IFPRS',TXTERR)
          ierr = 1
          goto 9000
      endif
*ICB      VAL2 = VALTYQ(.TRUE.,IDELIM)
*ICB      if((idelim.gt.0 .and. idelim.ne.ichar(')')) .or. nchscn().eq.0)
*ICB     + goto 9000
C
C     Check for the condition

      COND(ICOND) = QMNCON(VAL1, VAL2, NCOND, IERR)
C
C     If more conditionals on expression line, put TYPSCN buffer back.
C
      IF(TXT2 .NE. ' ') THEN
          IF(ICOND .GE. 5) GOTO 5000
          IF(TXT2(1:1).EQ.'.') THEN
              LENT = LNBLNK(TXT2)
              CALL M_LUPC(TXT2(2:LENT),TXT1)
              TXT2 = TXT1
          ENDIF
          LENT = LNBLNK(TXT2)
          CALL QUOTYQ(TXT2(1:LENT))
          GOTO 1500
      ENDIF

 5000 CONTINUE
*
*     AND and OR the series of conditions into a final overall condition
*
      NIFLV = IIFLV(NTDEP)
      QCOND(NIFLV,NTDEP) = COND(1)

      IF(ICOND .GT. 1) THEN
          DO 2000 ICLOCL = 2, ICOND
              IF(QTAG(ICLOCL)) THEN
                  QCOND(NIFLV,NTDEP) = QCOND(NIFLV,NTDEP) .AND.
     +             COND(ICLOCL)
              ELSE
                  QCOND(NIFLV,NTDEP) = QCOND(NIFLV,NTDEP) .OR.
     +             COND(ICLOCL)
              ENDIF
 2000     CONTINUE
      ENDIF
*
*     Set the logical that says whether the IF block was ever true
*     This is needed for ELSE
*
      if(.not.qcondi(niflv,ntdep) .and. qcond(niflv,ntdep)) then
        qcondi(niflv,ntdep) = .true.
      endif

9000  CONTINUE

      RETURN
      END
