      DOUBLE PRECISION FUNCTION XMNFR2(LMODEL,WBIN,WPAR,NPAR,X)
C
      IMPLICIT NONE
C
      INTEGER LMODEL,NPAR
      REAL X
      DOUBLE PRECISION WBIN,WPAR(20)
C
      DOUBLE PRECISION EVAL,Z,B1,B2,B3,B4,BOT,AF,C1,C2
      INTEGER NCALL1,NCALL2,NCALL3,NCALL4,NCALL5
C
      DATA NCALL1/0/,NCALL2/0/,NCALL3/0/,NCALL4/0/,NCALL5/0/
C
      XMNFR2 = 0.0
      GOTO(1000,2000,3000,4000,5000) LMODEL
C
C     PETERSON FUNCTION
C
 1000 CONTINUE
      NCALL1 = NCALL1 + 1
      IF(NCALL1.EQ.1) THEN
          WRITE(6,'('' Using Peterson Fragmentation Function'')')
      ENDIF
      Z = DBLE(X)
      IF(Z.LE.0.0D0.OR.Z.GE.1.0D0) THEN
          XMNFR2=0.0D0
      ELSE
          BOT = Z*(1.0D0-1.0D0/Z-WPAR(2)/(1.0D0-Z))**2
          XMNFR2 = WPAR(1) / BOT * WBIN
      ENDIF
      RETURN
C
C     KARTVELISHVELI
C
 2000 CONTINUE
      NCALL2 = NCALL2 + 1
      IF(NCALL2.EQ.1) THEN
          WRITE(6,'('' Using Kartvelishveli Fragmentation''
     1     ,'' Function'')')
      ENDIF
      Z = DBLE(X)
      IF(Z.LE.0.0D0.OR.Z.GE.1.0D0) THEN
          XMNFR2 = 0.0D0
      ELSE
          XMNFR2 =  WPAR(1) * ( Z**WPAR(2)*(1.0D0-Z) ) * WBIN
      ENDIF
      RETURN
C
C     ANDERSSON
C
 3000 CONTINUE
      NCALL3 = NCALL3 + 1
      IF(NCALL3.EQ.1) THEN
          WRITE(6,'('' Using Andersson Fragmentation Function'')')
      ENDIF
      Z = DBLE(X)
      IF(Z.LE.0.0D0.OR.Z.GE.1.0D0) THEN
          XMNFR2 = 0.0D0
      ELSE
          AF=(1.0D0/Z)*( (1.0D0-Z)**WPAR(2) )
          EVAL = ((-1.0D0*WPAR(3)*WPAR(4)**2)/Z)
C
C         UNDERFLOW PROTECTION
C
          IF(DABS(EVAL) .LE. 50.0D0) THEN
              XMNFR2 = WPAR(1)*AF*DEXP(EVAL)*WBIN
          ELSE
              XMNFR2 = 0.0D0
          ENDIF
      ENDIF
      RETURN
C
C     COLLINS
C
 4000 CONTINUE
      NCALL4 = NCALL4 + 1
      IF(NCALL4.EQ.1) THEN
          WRITE(6,'('' Using Collins Fragmentation Function'')')
      ENDIF
      Z = DBLE(X)
      IF(Z.LE.0.0D0.OR.Z.GE.1.0D0) THEN
          XMNFR2 = 0.0D0
      ELSE
          C1= ( (1.0D0-Z)/Z + (2.0D0-Z)*WPAR(2)/(1.0D0-Z) ) *
     +     ( 1.0D0 + Z**2)
          C2 = (1.0D0 - 1.0D0/Z - WPAR(2)/(1.0D0-Z) )
          XMNFR2 = WPAR(1) * C1 / C2**2 * WBIN
      ENDIF
      RETURN
C
C     BOWLER
C
 5000 CONTINUE
      NCALL5 = NCALL5 + 1
      IF(NCALL5.EQ.1) THEN
          WRITE(6,'('' Using Bowler Fragmentation Function'')')
      ENDIF
      Z = DBLE(X)
      IF(Z.LE.0.0D0.OR.Z.GE.1.0D0) THEN
          XMNFR2 = 0.0D0
      ELSE
          B1 = WPAR(1) * ( (1.0D0-Z)**WPAR(2) ) * (WPAR(3)/Z)
          B2 = -1.0D0 * WPAR(3)*(WPAR(4)**2)
          B3 = (WPAR(5)**2/(Z*WPAR(4)**2)) - 1.0D0 -
     1     DLOG(WPAR(5)**2/(Z*WPAR(4)**2))
          IF(DABS(B2*B3) .LE. 50.0D0) THEN
              B4 = DEXP(B2*B3)
              XMNFR2 = B1 * B4 * WBIN
          ELSE
              XMNFR2 = 0.0D0
          ENDIF
      ENDIF
C
      RETURN
      END
