#include "udm_config.h"

#ifdef UDM_WITH_EXEC_CGI

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>

#include "udm_common.h"
#include "udm_utils.h"
#include "udm_parseurl.h"
#include "udm_execget.h"
#include "udm_log.h"


/*
#define DEBUG_EXECGET
*/

int UdmExecGet(UDM_AGENT * Indexer,UDM_DOCUMENT * Doc, UDM_URL * Url){
	int res;
	char * args;
	char cmdline[1024];
	FILE * f;
	int size=0;

	Indexer->buf[0]='\0';

	if((args=strchr(Url->filename,'?'))){
		*args='\0';
		args++;
	}
	sprintf(cmdline,"%s%s",Url->path,Url->filename);
	
	if(!strcmp(Url->schema,"exec")){
		if(args){
			sprintf(UDM_STREND(cmdline)," \"%s\"",args);
		}
	}else
	if(!strcmp(Url->schema,"cgi")){
		/* Non-parsed-headers CGI return HTTP status itself */
		if(UDM_STRNCMP(Url->filename,"nph-")){
			sprintf(Indexer->buf,"HTTP/1.0 200 OK\r\n");
			size=strlen(Indexer->buf);
		}
		UdmSetEnv("QUERY_STRING",args?args:"");
		UdmSetEnv("REQUEST_METHOD","GET");
	}

#ifdef DEBUG_EXECGET
	fprintf(stderr,"cmd='%s'\n",cmdline);
#endif

	UdmLog(Indexer,UDM_LOG_DEBUG,"Starting program '%s'",cmdline);

	f=popen(cmdline,"r");

	/* Remove set variables */
	if(!strcmp(Url->schema,"cgi")){
		UdmUnsetEnv("REQUEST_METHOD");
		UdmUnsetEnv("QUERY_STRING");
	}

	if(f){
		int fd,bytes;
		
		fd=fileno(f);
		while((bytes=read(fd,Indexer->buf+size,Indexer->Conf->max_doc_size))){
			size+=bytes;
			Indexer->buf[size]='\0';
		}
		res=pclose(f);
	}else{
		int status;
		printf("error=%s\n",strerror(errno));
		switch(errno){
			case ENOENT: status=404;break; /* Not found */
			case EACCES: status=403;break; /* Forbidden*/
			default: status=500;
		}
		sprintf(Indexer->buf,"HTTP/1.0 %d %s\r\n\r\n",status,strerror(errno));
		size=strlen(Indexer->buf);
	}
#ifdef DEBUG_EXECGET
	fprintf(stderr,"buf='%s'\n",Indexer->buf);
#endif
	return(size);
}

#endif
