#ifndef PARTICLE_H
#define PARTICLE_H

#include "MovingObjectBase.h"

class ControllableObjectBase;
class ProjectileBase;
class ParticleFountainBase;
class SAMBatteryBase;
class Tank;
class TurretBase;

//----------------------------------------------------------------------------
#define PARTICLE_VELOCITY 100
#define PARTICLES_GRADIENT_SIZE 64



//----------------------------------------------------------------------------
class ParticleSurfaces : public SurfacesBase
{
    SURFACES_SINGLETON_OBJECT(ParticleSurfaces);

  public:

    inline const SDL_Surface *getSurface(int i) const
    {
        assert(i >= -1 && i < PARTICLES_GRADIENT_SIZE);
        return i == -1 ? m_white : m_gradient[i];
    }

    inline unsigned getGradientSize() const
    {
        return PARTICLES_GRADIENT_SIZE;
    }

  private:

    /// A white particle surface.
    SDL_Surface *m_white;

    /// Gradient surfaces for explosion particles.
    SDL_Surface *m_gradient[PARTICLES_GRADIENT_SIZE];
};


//----------------------------------------------------------------------------
class ParticleBase : public MovingObjectBase
{
  public:
    //------------------------------------------------------------------------
    ~ParticleBase();

    //------------------------------------------------------------------------
    inline void setLifeCount(unsigned lifeCount) { m_lifeCount = lifeCount; }
    inline void setGravity() { m_gravity = true; }
    void setGradient(unsigned fineSweepSpeed = 100);

    //------------------------------------------------------------------------
    void update();

    //------------------------------------------------------------------------
    void updateSurface();

  protected:
    //------------------------------------------------------------------------
    ParticleBase(const ObjectBase *creator);

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    /// The number of frames, this particle will live.
    unsigned m_lifeCount;

    /// True, if gravity shall have effect on this particle.
    bool m_gravity;

    /// The current gradient index of this particle.
    bool m_gradient;
    unsigned m_gradientFineIndex;
    unsigned m_gradientFineIndexIncrement;
};


//----------------------------------------------------------------------------
class ThrustParticle : public ParticleBase
{
  public:
    ThrustParticle(const ObjectBase *creator);
    ~ThrustParticle();

  protected:
    /// Called by the constructor to initialize all members.
    void init();
};

//----------------------------------------------------------------------------
class ExplosionParticle : public ParticleBase
{
  public:
    ExplosionParticle(const ObjectBase *creator);
    ~ExplosionParticle();
};


//----------------------------------------------------------------------------
class FountainParticle : public ParticleBase
{
  public:
    FountainParticle(const ParticleFountainBase *creator);
    ~FountainParticle();

  protected:
    /// Called by the constructor to initialize all members.
    void init();
};

#endif //PARTICLE_H
