#include <stdio.h>
#include <stdlib.h>

#include <apr.h>
#include <apr_pools.h>

#include <libbttracker.h>
#include <libxml/tree.h>


int main(int argc, char** argv) {
    apr_pool_t* p = NULL;
    char* result;
    btt_infohash hash;
    btt_infohash in_hash;
    xmlDocPtr document;

    printf("1..1\n");
    
    if(apr_pool_initialize() != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_initialize() failed!\n");
        fflush(stderr);
        exit(2);
    }
 
    if(apr_pool_create(&p, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_create() failed!\n");
        fflush(stderr);
        exit(3);
    }

    
    memcpy(&hash, &new_btt_infohash, sizeof(hash));
    memcpy(&in_hash, &new_btt_infohash, sizeof(hash));
    strcpy(hash.filename, "Foo & Bar's Excellent Adventure");
    hash.infohash[10] = 0x40;
    hash.filesize = 1024;
    hash.peers = 1;
    hash.seeds = 2;
    
    document = btt_infohash2xmlDoc(p, &hash);
    in_hash = btt_xml2infohash(p, document->children);
    
    if(!memcmp(&hash, &in_hash, sizeof(hash))) {
        printf("ok 1 - hash and in_hash are the same\n");
    } else {
        printf("not ok 1 - hash and in_hash are the same\n");
        btt_infohash2xml(p, &hash, &result);
        fprintf(stderr, "original: %s\n", result);
        btt_infohash2xml(p, &in_hash, &result);
        fprintf(stderr, "converted: %s\n", result);
    }
    
    exit(0);
}
