#include "modeline.h"

/* display the logo */
void Logo (void)
{
  printf ("\n         -=> %s %s <=- \n", PACKAGE, VERSION);
  printf ("    By Anders Ostrem and Vidar Hoel\n\n");
}

/* print usage and option list */
void Usage (void)
{
  Logo ();
  
  printf ("Usage: ModeLine [options]\n\n");
  printf ("    -h, --help           This help-screen\n");
  printf ("    -W, --width          The display width you want\n");
  printf ("    -H, --heigth         The display heigth you want\n");
  printf ("    -z, --hertz          The refreshrate you want\n");
  printf ("    -d, --double         Specify a double scan mode (each line drawn twice)\n");
  printf ("    -i, --interlaced     Specify an interlaced mode\n");
  printf ("    -f, --file           Specify a different configfile for monitor limits\n");
  printf ("    -g, --noguess        Do NOT guess width or heigth if only one is given\n");
  printf ("        --guess          Try to guess width and heigth (default)\n");
  printf ("    -a, --aspect         Specify an aspect ratio to use for guessing (default 4:3)\n");
  printf ("                         useful for certain modes (like 1280x1024)\n");
  printf ("    -w, --wide           Use if you have a WideScreen monitor (16:9)\n");
  printf ("        --xfree          Output XFree86 and SVGAlib compatible modelines (default)\n");
  printf ("        --fb[=depth]     Output FrameBuffer modes for fb.modes\n");
  printf ("        --matrox[=depth] Output a lilo append line for Matrox FrameBuffer\n");
  printf ("    -m, --memory         Give amount of videomemory (syntax where x is amount:\n");
  printf ("                          xM : Megabytes  xk : kilobytes  xb : bytes\n");
  printf ("        --nowarn         Don't display the warning in the beginning\n");
  printf ("    -q, --quiet          Be quiet\n");
  printf ("    -v, --verbose        Be verbose\n\n");
}

/* process value from --aspect option into something usable */
int GetRatio (const char *arg)
{
  char as_x [4], as_y [4];
  int pos;
  
  if (!strstr (arg, ":"))
  {
    printf ("unrecognized format...  should be x:y\n");
    return 1;
  }
  
  pos = strcspn (arg, ":");
  strcpy (as_x, arg);
  as_x [pos] = 0;
  strcpy (as_y, &arg [pos + 1]);
  pos = strcspn (arg, "\n");
  as_y [pos] = 0;
  
  ml.aspect_x = strtol (as_x, NULL, 10);
  ml.aspect_y = strtol (as_y, NULL, 10);
  
  return 0;
}

/* process commandline options */
int CheckArgs (int argc, char **argv)
{
  int option_current = -1;  /* current option */
  int option_index = 0;     /* option index */
  
  while (1)
  {
    /* set up list of long-options */
    static struct option long_options [] =
    {
      {"help", 0, 0, 0},
      {"width", 1, 0, 0},
      {"heigth", 1, 0, 0},
      {"hertz", 1, 0, 0},
      {"aspect", 1, 0, 0},
      {"wide", 0, &ml.flags.widescreen, 1},
      {"double", 0, &ml.flags.doublescan, 1},
      {"interlaced", 0, &ml.flags.interlaced, 1},
      {"verbose", 0, &ml.flags.verbose, 1},
      {"quiet", 0, &ml.flags.quiet, 1},
      {"nowarn", 0, &ml.flags.warn, 0},
      {"file", 1, 0, 0},
      {"noguess", 0, &ml.flags.guess, 0},
      {"guess", 0, &ml.flags.guess, 1},
      {"xfree", 0, &ml.output, 1},
      {"fb", 2, 0, 0},
      {"matrox", 2, 0, 0},
      {"memory", 1, 0, 0},
      {0, 0, 0, 0}
    };
    
    option_current = getopt_long (argc, argv, "hW:H:z:a:wvqf:gm:di", long_options, &option_index);
    if (option_current == -1) break;
    
    switch (option_current)
    {
      case 0:
        /* If this option set a flag, do nothing else now. */
        /* --wide, --double, --interlaced, --verbose, --quiet, --nowarn, */
        /* --noguess, --quess, --xfree */
        if (long_options [option_index].flag != 0)
          break;
        
        if (option_index == 0)    /* --help */
        {
          Usage ();
          return 1;
        }
        
        if (option_index == 1)    /* --width */
        {
          ml.width = strtol (optarg, NULL, 10);
          break;
        }
        
        if (option_index == 2)    /* --height */
        {
          ml.heigth = strtol (optarg, NULL, 10);
          break;
        }
        
        if (option_index == 3)    /* --hertz */
        {
          ml.refresh = strtol (optarg, NULL, 10);
          break;
        }
        
        if (option_index == 4)    /* --aspect */
        {
          if (GetRatio (optarg)) return 1;
          break;
        }
        
        if (option_index == 11)   /* --file */
        {
          ml.File = optarg;
          break;
        }
        
        if (option_index == 15)   /* --fb */
        {
          ml.output = 2;
          if (optarg) ml.depth = strtol (optarg, NULL, 10);
          break;
        }
        
        if (option_index == 16)   /* --matrox */
        {
          ml.output = 3;
          if (optarg) ml.depth = strtol (optarg, NULL, 10);
          break;
        }
        
        if (option_index == 17)   /* --memory */
        {
          ml.Memory = GetMemory (optarg);
          break;
        }
        
        Usage ();
        return 1;
        
      case 'h':
        Usage ();
        return 1;
      case 'W':
        ml.width = strtol (optarg, NULL, 10);
        break;
      case 'H':
        ml.heigth = strtol (optarg, NULL, 10);
        break;
      case 'z':
        ml.refresh = strtol (optarg, NULL, 10);
        break;
      case 'a':
        if (GetRatio (optarg)) return 1;
        break;
      case 'w':
        ml.flags.widescreen = 1;
        break;
      case 'd':
        ml.flags.doublescan = 1;
        break;
      case 'i':
        ml.flags.interlaced = 1;
        break;
      case 'v':
        ml.flags.verbose = 1;
        break;
      case 'q':
        ml.flags.quiet = 1;
        break;
      case 'f':
        ml.File = optarg;
        break;
      case 'g':
        ml.flags.guess = 0;
        break;
      case 'm':
        ml.Memory = GetMemory (optarg);
        break;
      case '?':
        Usage ();
        return 1;
      default:
        Die ("error processing arguments\n");
    }
    
  }
  
  if (optind < argc)
  {
    char tmp [81];
    char c [21];
    
    sprintf (tmp, "non-option ARGV-elements: ");
    while (optind < argc && strlen (tmp) < 80)
    {
      sprintf (c, "%s ", argv [optind++]);
      strncat (tmp, c, 20);
    }
    
    Die ("%s\n", tmp);
  }
  
  return 0;
}
