/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: mlocale.c,v 1.28 2001/10/24 18:19:14 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "mlocale.h"

int init_locale (mconfig *conf) {
#ifdef HAVE_GETTEXT
	setlocale(LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
#endif

	return 0;
}

char *mhttpcodes(int status) {
	switch (status) {
		case 100:	return _("Continue");
		case 101:	return _("Switching Protocols");
		case 200:	return _("OK");
		case 201:	return _("Created");
		case 202:	return _("Accepted");
		case 203:	return _("Non-Authoritative Information");
		case 204:	return _("No Content");
		case 205:	return _("Reset Content");
		case 206:	return _("Partial Content");
		case 300:	return _("Multiple Choices");
		case 301:	return _("Moved Permanently");
		case 302:	return _("Found");
		case 303:	return _("See Other");
		case 304:	return _("Not Modified");
		case 305:	return _("Use Proxy");
		case 307:	return _("Moved Temporarily");
		case 400:	return _("Bad Request");
		case 401:	return _("Unauthorized");
		case 402:	return _("Payment Required");
		case 403:	return _("Forbidden");
		case 404:	return _("Not Found");
		case 405:	return _("Method Not Allowed");
		case 406:	return _("Not Acceptable");
		case 407:	return _("Proxy Authentication Required");
		case 408:	return _("Request Timeout");
		case 409:	return _("Conflict");
		case 410:	return _("Gone");
		case 411:	return _("Length Required");
		case 412:	return _("Precondition Failed");
		case 413:	return _("Request Entity Too Large");
		case 414:	return _("Request-URI Too Long");
		case 415:	return _("Unsupported Media Type");
		case 416:	return _("Requested Range Not Satisfiable");
		case 417:	return _("Expectation Failed");
		case 500:	return _("Internal Server Error");
		case 501:	return _("Not Implemented");
		case 502:	return _("Bad Gateway");
		case 503:	return _("Service Unavailable");
		case 504:	return _("Gateway Timeout");
		case 505:	return _("HTTP Version Not Supported");
		default:	return _("Unknown status code");
	}
}

long long isondx(char *str) {
	int i = 0;
	int j = 3;
	if (!str || strlen(str) > 4) return M_RESOLV_UNKNOWN_ERROR;
	if (!isalpha(*str)) return M_RESOLV_UNRESOLVED;

	while (*str) {
		i |= tolower(*str) << (8*j);
		str++;
		j--;
	}
	
	return i;
}

#define NDX2(x,y)	x << 24 | y << 16
#define NDX3(x,y,z)	x << 24 | y << 16 | z << 8 
#define NDX4(x,y,z,a)	x << 24 | y << 16 | z << 8 | a

char *misoname(char *str) {
	switch(isondx(str)) {
/* .ac */	case NDX2('a','c'):	return _("Ascension Island");
/* .ad */	case NDX2('a','d'): 	return _("Andorra");	
/* .ae */	case NDX2('a','e'):	return _("United Arab Emirates");
/* .af */	case NDX2('a','f'):	return _("Afghanistan");
/* .ag */	case NDX2('a','g'):	return _("Antigua and Barbuda");
/* .ai */	case NDX2('a','i'):	return _("Anguilla");
/* .al */	case NDX2('a','l'):	return _("Albania");
/* .am */	case NDX2('a','m'):	return _("Armenia");
/* .an */	case NDX2('a','n'):	return _("Netherlands Antilles");
/* .ao */	case NDX2('a','o'):	return _("Angola");
/* .aq */	case NDX2('a','q'):	return _("Antarctica");
/* .ar */	case NDX2('a','r'):	return _("Argentina");
/* .arpa */	case NDX4('a','r','p','a'):	return _("Old style Arpanet (arpa)");
/* .as */	case NDX2('a','s'):	return _("American Samoa");
/* .at */	case NDX2('a','t'):	return _("Austria");
/* .au */	case NDX2('a','u'):	return _("Australia");
/* .aw */	case NDX2('a','w'):	return _("Aruba");
/* .az */	case NDX2('a','z'):	return _("Azerbaijan");
/* .ba */	case NDX2('b','a'):	return _("Bosnia and Herzegovina");
/* .bb */	case NDX2('b','b'):	return _("Barbados");
/* .bd */	case NDX2('b','d'):	return _("Bangladesh");
/* .be */	case NDX2('b','e'):	return _("Belgium");
/* .bf */	case NDX2('b','f'):	return _("Burkina Faso");
/* .bg */	case NDX2('b','g'):	return _("Bulgaria");
/* .bh */	case NDX2('b','h'):	return _("Bahrain");
/* .bi */	case NDX2('b','i'):	return _("Burundi");
/* .bj */	case NDX2('b','j'):	return _("Benin");
/* .bm */	case NDX2('b','m'):	return _("Bermuda");
/* .bn */	case NDX2('b','n'):	return _("Brunei Darussalam");
/* .bo */	case NDX2('b','o'):	return _("Bolivia");
/* .br */	case NDX2('b','r'):	return _("Brasil");
/* .bs */	case NDX2('b','s'):	return _("Bahamas");
/* .bt */	case NDX2('b','t'):	return _("Bhutan");
/* .bv */	case NDX2('b','v'):	return _("Bouvet Island");
/* .bw */	case NDX2('b','w'):	return _("Botswana");
/* .by */	case NDX2('b','y'):	return _("Belarus");
/* .bz */	case NDX2('b','z'):	return _("Belize");
/* .ca */	case NDX2('c','a'):	return _("Canada");
/* .cc */	case NDX2('c','c'):	return _("Cocos (Keeling) Islands");
/* .cd */	case NDX2('c','d'):	return _("Congo, Democratic Republic of the");
/* .cf */	case NDX2('c','f'):	return _("Central African Republic");
/* .cg */	case NDX2('c','g'):	return _("Congo");
/* .ch */	case NDX2('c','h'):	return _("Switzerland");
/* .ci */	case NDX2('c','i'):	return _("Ivory Coast");
/* .ck */	case NDX2('c','k'):	return _("Cook Islands");
/* .cl */	case NDX2('c','l'):	return _("Chile");
/* .cm */	case NDX2('c','m'):	return _("Cameroon");
/* .cn */	case NDX2('c','n'):	return _("China");
/* .co */	case NDX2('c','o'):	return _("Colombia");
/* .com */	case NDX3('c','o','m'):	return _("US Commercial");
/* .cr */	case NDX2('c','r'):	return _("Costa Rica");
/* .cs */	case NDX2('c','s'):	return _("Czechoslovakia (former)");
/* .cu */	case NDX2('c','u'):	return _("Cuba");
/* .cv */	case NDX2('c','v'):	return _("Cape Verde");
/* .cx */	case NDX2('c','x'):	return _("Christmas Island");
/* .cy */	case NDX2('c','y'):	return _("Cyprus");
/* .cz */	case NDX2('c','z'):	return _("Czech Republic");
/* .edu */	case NDX3('e','d','u'):	return _("US Educational");
/* .de */	case NDX2('d','e'):	return _("Germany");
/* .dj */	case NDX2('d','j'):	return _("Djibouti");
/* .dk */	case NDX2('d','k'):	return _("Denmark");
/* .dm */	case NDX2('d','m'):	return _("Dominica");
/* .do */	case NDX2('d','o'):	return _("Dominican Republic");
/* .dz */	case NDX2('d','z'):	return _("Algeria");
/* .ec */	case NDX2('e','c'):	return _("Ecuador");
/* .ee */	case NDX2('e','e'):	return _("Estonia");
/* .eg */	case NDX2('e','g'):	return _("Egypt");
/* .eh */	case NDX2('e','h'):	return _("Western Sahara");
/* .er */	case NDX2('e','r'):	return _("Eritrea");
/* .es */	case NDX2('e','s'):	return _("Spain");
/* .et */	case NDX2('e','t'):	return _("Ethiopia");
/* .fi */	case NDX2('f','i'):	return _("Finland");
/* .fj */	case NDX2('f','j'):	return _("Fiji");
/* .fk */	case NDX2('f','k'):	return _("Falkland Islands (Malvinas)");
/* .fm */	case NDX2('f','m'):	return _("Micronesia");
/* .fo */	case NDX2('f','o'):	return _("Faroe Islands");
/* .fr */	case NDX2('f','r'):	return _("France");
/* .fx */	case NDX2('f','x'):	return _("France, Metropolitan");
/* .ga */	case NDX2('g','a'):	return _("Gabon");
/* .gb */	case NDX2('g','b'):	return _("Great Britain (UK)");
/* .gd */	case NDX2('g','d'):	return _("Grenada");
/* .ge */	case NDX2('g','e'):	return _("Georgia");
/* .gf */	case NDX2('g','f'):	return _("French Guiana");
/* .gh */	case NDX2('g','h'):	return _("Ghana");
/* .gi */	case NDX2('g','i'):	return _("Gibraltar");
/* .gl */	case NDX2('g','l'):	return _("Greenland");
/* .gm */	case NDX2('g','m'):	return _("Gambia");
/* .gn */	case NDX2('g','n'):	return _("Guinea");
/* .gov */	case NDX3('g','o','v'):	return _("US Government");
/* .gp */	case NDX2('g','p'):	return _("Guadeloupe");
/* .gq */	case NDX2('g','q'):	return _("Equatorial Guinea");
/* .gr */	case NDX2('g','r'):	return _("Greece");
/* .gs */	case NDX2('g','s'):	return _("S. Georgia and S. Sandwich Isls.");
/* .gt */	case NDX2('g','t'):	return _("Guatemala");
/* .gu */	case NDX2('g','u'):	return _("Guam");
/* .gw */	case NDX2('g','w'):	return _("Guinea-Bissau");
/* .gy */	case NDX2('g','y'):	return _("Guyana");
/* .hk */	case NDX2('h','k'):	return _("Hong Kong");
/* .hm */	case NDX2('h','m'):	return _("Heard and McDonald Islands");
/* .hn */	case NDX2('h','n'):	return _("Honduras");
/* .hr */	case NDX2('h','r'):	return _("Croatia");
/* .ht */	case NDX2('h','t'):	return _("Haiti");
/* .hu */	case NDX2('h','u'):	return _("Hungary");
/* .id */	case NDX2('i','d'):	return _("Indonesia");
/* .ie */	case NDX2('i','e'):	return _("Ireland");
/* .il */	case NDX2('i','l'):	return _("Israel");
/* .in */	case NDX2('i','n'):	return _("India");
/* .info */	case NDX4('i','n','f','o'):	return _("Informational (info)");
/* .int */	case NDX3('i','n','t'):	return _("International (int)");
/* .ir */	case NDX2('i','r'):	return _("Iran");
/* .is */	case NDX2('i','s'):	return _("Iceland");
/* .it */	case NDX2('i','t'):	return _("Italy");
/* .je */	case NDX2('j','e'):	return _("Jersey");
/* .jm */	case NDX2('j','m'):	return _("Jamaica");
/* .jo */	case NDX2('j','o'):	return _("Jordan");
/* .jp */	case NDX2('j','p'):	return _("Japan");
/* .ke */	case NDX2('k','e'):	return _("Kenya");
/* .kg */	case NDX2('k','g'):	return _("Kyrgyzstan");
/* .kh */	case NDX2('k','h'):	return _("Cambodia");
/* .ki */	case NDX2('k','i'):	return _("Kiribati");
/* .km */	case NDX2('k','m'):	return _("Comoros");
/* .kn */	case NDX2('k','n'):	return _("Saint Kitts and Nevis");
/* .kp */	case NDX2('k','p'):	return _("Korea (North)");
/* .kr */	case NDX2('k','r'):	return _("Korea (South)");
/* .kw */	case NDX2('k','w'):	return _("Kuwait");
/* .ky */	case NDX2('k','y'):	return _("Cayman Islands");
/* .kz */	case NDX2('k','z'):	return _("Kazakhstan");
/* .lb */	case NDX2('l','b'):	return _("Lebanon");
/* .lc */	case NDX2('l','c'):	return _("Saint Lucia");
/* .li */	case NDX2('l','i'):	return _("Liechtenstein");
/* .lk */	case NDX2('l','k'):	return _("Sri Lanka");
/* .lr */	case NDX2('l','r'):	return _("Liberia");
/* .ls */	case NDX2('l','s'):	return _("Lesotho");
/* .lt */	case NDX2('l','t'):	return _("Lithuania");
/* .lu */	case NDX2('l','u'):	return _("Luxembourg");
/* .lv */	case NDX2('l','v'):	return _("Latvia");
/* .ly */	case NDX2('l','y'):	return _("Lybia");
/* .ma */	case NDX2('m','a'):	return _("Morocco");
/* .mc */	case NDX2('m','c'):	return _("Monaco");
/* .md */	case NDX2('m','d'):	return _("Moldova");
/* .mg */	case NDX2('m','g'):	return _("Madagascar");
/* .mh */	case NDX2('m','h'):	return _("Marshall Islands");
/* .mil */	case NDX3('m','i','l'):	return _("US Military");
/* .mk */	case NDX2('m','k'):	return _("Macedonia");
/* .ml */	case NDX2('m','l'):	return _("Mali");
/* .mm */	case NDX2('m','m'):	return _("Myanmar");
/* .mn */	case NDX2('m','n'):	return _("Mongolia");
/* .mo */	case NDX2('m','o'):	return _("Macau");
/* .mp */	case NDX2('m','p'):	return _("Northern Mariana Islands");
/* .mq */	case NDX2('m','q'):	return _("Martinique");
/* .mr */	case NDX2('m','r'):	return _("Mauritania");
/* .ms */	case NDX2('m','s'):	return _("Montserrat");
/* .mt */	case NDX2('m','t'):	return _("Malta");
/* .mu */	case NDX2('m','u'):	return _("Mauritius");
/* .mv */	case NDX2('m','v'):	return _("Maldives");
/* .mw */	case NDX2('m','w'):	return _("Malawi");
/* .mx */	case NDX2('m','x'):	return _("Mexico");
/* .my */	case NDX2('m','y'):	return _("Malaysia");
/* .mz */	case NDX2('m','z'):	return _("Mozambique");
/* .na */	case NDX2('n','a'):	return _("Namibia");
/* .nato */	case NDX4('n','a','t','o'):	return _("Nato field");
/* .nc */	case NDX2('n','c'):	return _("New Caledonia");
/* .ne */	case NDX2('n','e'):	return _("Niger");
/* .net */	case NDX3('n','e','t'):	return _("Network");
/* .nf */	case NDX2('n','f'):	return _("Norfolk Island");
/* .ng */	case NDX2('n','g'):	return _("Nigeria");
/* .ni */	case NDX2('n','i'):	return _("Nicaragua");
/* .nl */	case NDX2('n','l'):	return _("Netherland");
/* .no */	case NDX2('n','o'):	return _("Norway");
/* .np */	case NDX2('n','p'):	return _("Nepal");
/* .nr */	case NDX2('n','r'):	return _("Nauru");
/* .nt */	case NDX2('n','t'):	return _("Neutral Zone");
/* .nu */	case NDX2('n','u'):	return _("Niue");
/* .nz */	case NDX2('n','z'):	return _("New Zealand");
/* .om */	case NDX2('o','m'):	return _("Oman");
/* .org */	case NDX3('o','r','g'):	return _("Organizational");
/* .pa */	case NDX2('p','a'):	return _("Panama");
/* .pe */	case NDX2('p','e'):	return _("Peru");
/* .pf */	case NDX2('p','f'):	return _("French Polynesia");
/* .pg */	case NDX2('p','g'):	return _("Papua New Guinea");
/* .ph */	case NDX2('p','h'):	return _("Philippines");
/* .pk */	case NDX2('p','k'):	return _("Pakistan");
/* .pl */	case NDX2('p','l'):	return _("Poland");
/* .pm */	case NDX2('p','m'):	return _("St. Pierre and Miquelon");
/* .pn */	case NDX2('p','n'):	return _("Pitcairn");
/* .pr */	case NDX2('p','r'):	return _("Puerto Rico");
/* .pt */	case NDX2('p','t'):	return _("Portugal");
/* .pw */	case NDX2('p','w'):	return _("Palau");
/* .py */	case NDX2('p','y'):	return _("Paraguay");
/* .qa */	case NDX2('q','a'):	return _("Qatar");
/* .re */	case NDX2('r','e'):	return _("Reunion");
/* .ro */	case NDX2('r','o'):	return _("Romania");
/* .ru */	case NDX2('r','u'):	return _("Russian Federation");
/* .rw */	case NDX2('r','w'):	return _("Rwanda");
/* .sa */	case NDX2('s','a'):	return _("Saudi Arabia");
/* .sb */	case NDX2('s','b'):	return _("Solomon Islands");
/* .sc */	case NDX2('s','c'):	return _("Seychelles");
/* .sd */	case NDX2('s','d'):	return _("Sudan");
/* .se */	case NDX2('s','e'):	return _("Sweden");
/* .sg */	case NDX2('s','g'):	return _("Singapore");
/* .sh */	case NDX2('s','h'):	return _("St. Helena");
/* .si */	case NDX2('s','i'):	return _("Slovenia");
/* .sj */	case NDX2('s','j'):	return _("Svalbard and Jan Mayen Islands");
/* .sk */	case NDX2('s','k'):	return _("Slovak Republic");
/* .sl */	case NDX2('s','l'):	return _("Sierra Leone");
/* .sm */	case NDX2('s','m'):	return _("San Marino");
/* .sn */	case NDX2('s','n'):	return _("Senegal");
/* .so */	case NDX2('s','o'):	return _("Somalia");
/* .sr */	case NDX2('s','r'):	return _("Suriname");
/* .st */	case NDX2('s','t'):	return _("Sao Tome and Principe");
/* .su */	case NDX2('s','u'):	return _("USSR (former)");
/* .sv */	case NDX2('s','v'):	return _("El Salvador");
/* .sy */	case NDX2('s','y'):	return _("Syria");
/* .sz */	case NDX2('s','z'):	return _("Swaziland");
/* .tc */	case NDX2('t','c'):	return _("Turks and Caicos Islands");
/* .td */	case NDX2('t','d'):	return _("Chad");
/* .tf */	case NDX2('t','f'):	return _("French Southern Territories");
/* .tg */	case NDX2('t','g'):	return _("Togo");
/* .th */	case NDX2('t','h'):	return _("Thailand");
/* .tj */	case NDX2('t','j'):	return _("Tajikistan");
/* .tk */	case NDX2('t','k'):	return _("Tokelau");
/* .tm */	case NDX2('t','m'):	return _("Turkmenistan");
/* .tn */	case NDX2('t','n'):	return _("Tunisia");
/* .to */	case NDX2('t','o'):	return _("Tonga");
/* .tp */	case NDX2('t','p'):	return _("East Timor");
/* .tr */	case NDX2('t','r'):	return _("Turkey");
/* .tt */	case NDX2('t','t'):	return _("Trinidad and Tobago");
/* .tv */	case NDX2('t','v'):	return _("Tuvalu");
/* .tw */	case NDX2('t','w'):	return _("Taiwan");
/* .tz */	case NDX2('t','z'):	return _("Tanzania");
/* .ua */	case NDX2('u','a'):	return _("Ukraine");
/* .ug */	case NDX2('u','g'):	return _("Uganda");
/* .uk */	case NDX2('u','k'):	return _("United Kingdom");
/* .um */	case NDX2('u','m'):	return _("US Minor Outlying Islands");
/* .us */	case NDX2('u','s'):	return _("United States");
/* .uy */	case NDX2('u','y'):	return _("Uruguay");
/* .uz */	case NDX2('u','z'):	return _("Uzbekistan");
/* .va */	case NDX2('v','a'):	return _("Vatican City State (Holy See)");
/* .vc */	case NDX2('v','c'):	return _("Saint Vincent and the Grenadines");
/* .ve */	case NDX2('v','e'):	return _("Venezuela");
/* .vg */	case NDX2('v','g'):	return _("Virgin Islands (British)");
/* .vi */	case NDX2('v','i'):	return _("Virgin Islands (U.S.)");
/* .vn */	case NDX2('v','n'):	return _("Viet Nam");
/* .vu */	case NDX2('v','u'):	return _("Vanuatu");
/* .wf */	case NDX2('w','f'):	return _("Wallis and Futuna Islands");
/* .ws */	case NDX2('w','s'):	return _("Samoa");
/* .ye */	case NDX2('y','e'):	return _("Yemen");
/* .yt */	case NDX2('y','t'):	return _("Mayotte");
/* .yu */	case NDX2('y','u'):	return _("Yugoslavia");
/* .za */	case NDX2('z','a'):	return _("South Africa");
/* .zm */	case NDX2('z','m'):	return _("Zambia");
/* .zr */	case NDX2('z','r'):	return _("Zaire");
/* .zw */	case NDX2('z','w'):	return _("Zimbabwe");
		
	        case NDX4('u','n','r','e'): return _("Unresolved");

/* unknown domains:
	.fsu -> illegally-used-at.fsu
	.wil2 -> server2.wil2
*/
		case M_RESOLV_UNKNOWN_ERROR:
			return NULL;
		case M_RESOLV_UNRESOLVED:
			return _("Unresolved");
		default:
			printf("unknown country code: %s -> 0x%08llx\n", str, isondx(str));
			return _("Unknown country");
	}
}
