# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: stagraph.tcl,v 2.15 2001/01/07 15:48:47 jfontain Exp $}


class dataStackedGraph {

    proc dataStackedGraph {this parentPath args} composite {[new frame $parentPath] $args} blt2DViewer {
        $widget::($this,path) [blt::barchart $widget::($this,path).graph\
            -title {} -barmode stack -topmargin 3 -bufferelements 0 -plotborderwidth 1 -plotbackground black -barwidth 0\
        ]
    } {
        set path $widget::($this,path).graph
        $path grid off                                                                                      ;# grid is on by default
        set graph [new bltGraph $path]
        pack $path -side left -fill both -expand 1
        set ($this,graph) $graph
        composite::complete $this
    }

    proc ~dataStackedGraph {this} {
        delete $($this,graph)
        if {[string length $composite::($this,-deletecommand)]>0} {
            uplevel #0 $composite::($this,-deletecommand)                                   ;# always invoke command at global level
        }
    }

    proc iconData {} {
        return {
            R0lGODdhJAAkAKUAAPj8+Hh4eDBgIDBgGHh8eKDocKjweJjgaJDYaIjQYAAAAIDIWHjAWHi4UHCwUHBIAGioSPDYSGCgQOjQSFiYQODISFCQOODESNi8SNC4
            SNCwSMisSMCkSMCcSLiYSBBgeLCQSLDY6ICEgKDQ4LCMSIiQiJjI2KiESJCYkIjA0KCkoIC4yKisqHiwwLi8uGiouMDEwGCgsMjQyNDY0ODk4Ojs6AAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAJAAkAAAG/kCAcCgMEI/G4zBZVBKZSijy6RQ0lQLBwHrcbpdFglhQEBAC4jRBYGgbzGm22xyoQ8nlO77A
            L2f3fGYAUgACB4dchYeLjI2LgoQCCJMIf5SXmJmQRWhrCZ+goaKjoQIKYnVEAgusra6vsK4CRpEMtre4ubq4s4NYDcDBwsPEwpuDnQIOy8zNzs/NpqhQCg8Q
            EA/Z2dfc3d7cvYQPEdkR5uYPEurr7O0S4UoPE/P09A8U+Pna9/kUx3ViHlQYSLBgNgsWshl8gNCCtDNQHlyYSLHixGwWKWqDd+QBho8gQ4ocGfIBrXgZUqpc
            ybLlygcEfCELqKGmzZs4c958cAoi8JEHG4IKHUq06FCTMn9yWMq0qdOnTZGK60C1qtWrWK3ClKmgazUPYMOK9fCh7IexZM3y9NozYFkQcOPC/RCibogPcuna
            /aCGgIi/Ij6MGPGBhGHDZQcrJmx2MWG/gEtILvHBhOUPJzJXtsy5s+fLBCaXQEEaxYcUqFOYTc26tWu+pVGomK3iw4rbuHPr3p2bL20VLIKz+NCiuPHjyJMf
            5yuchYvnLj68mE69uvXr1flCdwGjO4wPMcKLH0++/Hi+3mHIWC/DrPv38OOXJcBexoz79/vq38+fAP4ZNAQo4IAEFmjggTUkqOCCDDbo4INBAAA7
        }
    }

    proc options {this} {
        set samples [expr {$global::graphNumberOfIntervals+1}]
        # force size and interval values
        return [list\
            [list -deletecommand {} {}]\
            [list -draggable 0 0]\
            [list -height $global::viewerHeight]\
            [list -interval 5]\
            [list -samples $samples $samples]\
            [list -width $global::viewerWidth]\
        ]
    }

    proc set-deletecommand {this value} {}

    foreach option {-height -width} {
        proc set$option {this value} "\$widget::(\$this,path) configure $option \$value"
    }

    proc set-draggable {this value} {
        if {$composite::($this,complete)} {
            error {option -draggable cannot be set dynamically}
        }
        if {$value} {
            blt2DViewer::allowDrag $this
        }
    }

    proc set-interval {this value} {
        bltGraph::setRange $($this,graph) [expr {($composite::($this,-samples)-1)*$value}]
        bltGraph::updateGraduations $($this,graph)
    }

    proc set-samples {this value} {                                                                     ;# stored at composite level
        if {$composite::($this,complete)} {
            error {option -samples cannot be set dynamically}
        }
        bltGraph::setRange $($this,graph) [expr {($value-1)*$composite::($this,-interval)}]
    }

    proc updateTimeDisplay {this seconds} {
        bltGraph::xAxisUpdate $($this,graph) $seconds
    }

    proc newElement {this path args} {                                                          ;# invoked from 2D viewer base class
        return [eval new element $path $args]
    }

    proc updateElement {this element seconds value} {                           ;# value is either a valid number or the ? character
        element::update $element $seconds $value
    }

}


class dataStackedGraph {

    class element {

        proc element {this path args} switched {$args} {
            variable x$this
            variable y$this

            blt::vector create x${this}(0)                                                                     ;# x axis data vector
            blt::vector create y${this}(0)                                                                     ;# y axis data vector
            # use object identifier as element identifier, and handle void values
            $path element create $this -label {} -xdata x$this -ydata y$this
            set ($this,path) $path
            switched::complete $this
        }

        proc ~element {this} {
            variable x$this
            variable y$this

            blt::vector destroy x$this y$this
            $($this,path) element delete $this
            if {[string length $switched::($this,-deletecommand)]>0} {
                uplevel #0 $switched::($this,-deletecommand)                                ;# always invoke command at global level
            }
        }

        proc options {this} {
            return [list\
                [list -color black black]\
                [list -deletecommand {} {}]\
            ]
        }

        proc set-color {this value} {
            $($this,path) element configure $this -foreground $value
        }

        proc set-deletecommand {this value} {}                                                   ;# data is stored at switched level

        proc update {this x y} {                                                    ;# y is either a valid number or the ? character
            variable x$this
            variable y$this

            set path $($this,path)
            set minimum [$path xaxis cget -min]
            set length [llength [x$this search 0 $minimum]]
            incr length -2
            catch {                                                   ;# scroll by removing points to the left of the x axis minimum
                x$this delete :$length
                y$this delete :$length
            }
            set void [string equal $y ?]                                                                               ;# void value
            set fill 0
            if {[x$this length]>0} {                                                                            ;# after first point
                blt::vector create add(0)
                # create a vector with one value per half pixel (to avoid holes due to precision errors) between last and new value
                add seq [set x${this}(end)] $x [expr {([$path xaxis cget -max]-$minimum)/[$path extents plotwidth]/2}]
                add delete 0                                                                                    ;# remove last value
                if {[add length]<=1} {                                             ;# there was no room for some intermediate points
                    blt::vector destroy add
                } else {
                    set fill 1
                }
            }
            if {$fill} {                                                          ;# append a group of points to make a filled curve
                x$this append add
                blt::vector create limits(0)
                if {$void} {
                    limits append 0 0
                } else {
                    limits append [set y${this}(end)] $y
                }
                limits populate add [expr {[add length]-1}]
                add delete 0                                                                                    ;# remove last value
                y$this append add
                blt::vector destroy add limits
            } else {                                                                                        ;# append a single point
                x$this append $x                                                                                 ;# append new value
                if {$void} {
                    y$this append 0
                } else {
                    y$this append $y
                }
            }
        }

    }

}
