/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * MODULE NOTES:
 * @update  gess 4/1/98
 * 
 */

#ifndef __CParserContext
#define __CParserContext

#include "nsIParser.h"
#include "nsIURL.h"
#include "nsIDTD.h"
#include "nsIStreamListener.h"
#include "nsIRequest.h"
#include "nsScanner.h"
#include "nsString.h"
#include "nsCOMPtr.h"

/**
 * Note that the parser is given FULL access to all
 * data in a parsercontext. Hey, that what it's for!
 */

class CParserContext {

public:

    enum {eTransferBufferSize=4096};
    enum eContextType {eCTNone,eCTURL,eCTString,eCTStream};

   CParserContext(  nsScanner* aScanner,
                    void* aKey=0, 
                    eParserCommands aCommand=eViewNormal,
                    nsIRequestObserver* aListener=0, 
                    nsIDTD *aDTD=0, 
                    eAutoDetectResult aStatus=eUnknownDetect, 
                    PRBool aCopyUnused=PR_FALSE); 
    
    CParserContext( const CParserContext& aContext);
    ~CParserContext();

    nsresult GetTokenizer(PRInt32 aType, nsITokenizer*& aTokenizer);
    void  SetMimeType(const nsACString& aMimeType);

    nsCOMPtr<nsIRequest> mRequest; // provided by necko to differnciate different input streams
                                   // why is mRequest strongly referenced? see bug 102376.
    nsIDTD*              mDTD;
    nsIRequestObserver*  mListener;
    char*                mTransferBuffer;
    void*                mKey;
    nsITokenizer*        mTokenizer;
    CParserContext*      mPrevContext;
    nsScanner*           mScanner;
    
    nsCString            mMimeType;
    nsDTDMode            mDTDMode;
    
    eParserDocType       mDocType;
    eStreamState         mStreamListenerState; //this is really only here for debug purposes.
    eContextType         mContextType;
    eAutoDetectResult    mAutoDetectStatus;
    eParserCommands      mParserCommand;   //tells us to viewcontent/viewsource/viewerrors...

    PRBool               mMultipart;
    PRBool               mCopyUnused;
    PRUint32             mTransferBufferSize;
};



#endif


