
/*
 * @(#)mptool.h 1.2 01/01/18
 *
 * Copyright (c) Rich Burridge. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MPTOOL_MPTOOL_H__
#define __MPTOOL_MPTOOL_H__

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

enum icon_type {
	I_NORMAL, I_PRINTING
};

#include "base.h"
#include "header.h"
#include "help.h"
#include "main.h"
#include "option.h"
#include "print.h"
#include "text.h"
#include "util.h"
#include "xutil.h"

#define  MKTEMP             (void) mktemp

#define  BUFFERSIZE         10000	/* Buffer for constructing mp command. */
#define  MAXCHARS           100	   /* Maximum number of chars in user name. */
#define  MAXCOLUMNS         10	   /* Maximum number of columns per page. */
#define  MAXCOPIES          500	   /* Maximum number of copies of each file. */
#define  MAXICONCOLORS      8	   /* Maximum colors in mptool icon. */
#define  MAXLINELENGTH      1000   /* Maximum number of characters per line. */
#define  MAXPAGELENGTH      500	   /* Maximum number of lines per page. */
#define  MAXSTDHDRS         12	   /* Maximum number of standard headers. */
#define  MAXTABSIZE         50	   /* Maximum number of spaces in tab char. */
#define  MAXWORDS           10	   /* Maximum number of words in user name. */
#define  TITLE_LINE_HEIGHT  25

extern void do_print_cmd (char *);

#endif /* __MPTOOL_MPTOOL_H__ */
