/***************************************************************************
                          export.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EXPORT_H
#define EXPORT_H

#include <mp3list.h>

#include <fstream.h>
#include <qvaluelist.h>

class Export
{
public:
    Export(const Mp3List* list, const QString file);
    ~Export();

    void exportHtml(bool selected, bool tree);
    void exportM3u(bool selected, bool tree);
    void exportM3uPL();

private:
    void writeHtmlTabTh(ofstream* fwrite, const QValueList<int>& exItem, int numExItem);
    void writeHtmlTab(ofstream* fwrite, const QValueList<int>& exItem, bool createLinks, bool tree);
    void writeSelectedHtmlTab(ofstream* fwrite, const QValueList<int>& exItem, bool createLinks);
    void writeHtmlTabItem (ofstream* fwrite, const QValueList<int>& exItem, bool createLinks, QListViewItem* item, int numExItem);
    const Mp3List* list;
    QString file;
};

#endif

