/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JScrollBar;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.ScrollPaneConstants;
import com.sun.java.swing.ScrollPaneLayout;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ScrollPaneUI;
import com.sun.java.swing.plaf.UIResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants,
Serializable {
    protected JScrollPane scrollpane;
    protected ChangeListener vsbListener = this.createVSBListener();
    protected ChangeListener hsbListener = this.createHSBListener();
    protected ChangeListener viewportListener = this.createViewportListener();

    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.getSPLayout().getViewportBorderBounds(this.scrollpane);
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getSPLayout().preferredLayoutSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void installUI(JComponent jComponent) {
        this.scrollpane = (JScrollPane)jComponent;
        this.scrollpane.setLayout(this.createLayoutManager());
        JViewport jViewport = this.getViewport();
        JScrollBar jScrollBar = this.createVerticalScrollBar();
        JScrollBar jScrollBar2 = this.createHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.addChangeListener(this.viewportListener);
        }
        jScrollBar.getModel().addChangeListener(this.vsbListener);
        jScrollBar2.getModel().addChangeListener(this.hsbListener);
        this.scrollpane.add((Component)jScrollBar, "VERTICAL_SCROLLBAR");
        this.scrollpane.add((Component)jScrollBar2, "HORIZONTAL_SCROLLBAR");
        LookAndFeel.installBorder(this.scrollpane, "ScrollPane.border");
        LookAndFeel.installColorsAndFont(jComponent, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border border = this.scrollpane.getViewportBorder();
        if (border == null || border instanceof UIResource) {
            border = UIManager.getBorder("ScrollPane.viewportBorder");
            this.scrollpane.setViewportBorder(border);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        JViewport jViewport = this.getViewport();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.getHorizontalScrollBar();
        this.scrollpane.removeAll();
        this.scrollpane.setLayout(null);
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().removeChangeListener(this.vsbListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().removeChangeListener(this.hsbListener);
        }
        LookAndFeel.uninstallBorder(this.scrollpane);
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
        this.scrollpane = null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    protected ScrollPaneLayout getSPLayout() {
        return (ScrollPaneLayout)this.scrollpane.getLayout();
    }

    public int getVerticalScrollBarPolicy() {
        return this.getSPLayout().getVerticalScrollBarPolicy();
    }

    public void setVerticalScrollBarPolicy(int n) {
        this.getSPLayout().setVerticalScrollBarPolicy(n);
    }

    public int getHorizontalScrollBarPolicy() {
        return this.getSPLayout().getHorizontalScrollBarPolicy();
    }

    public void setHorizontalScrollBarPolicy(int n) {
        this.getSPLayout().setHorizontalScrollBarPolicy(n);
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.getSPLayout().getHorizontalScrollBar();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.getSPLayout().getVerticalScrollBar();
    }

    public void setViewport(JViewport jViewport) {
        JViewport jViewport2 = this.getViewport();
        if (jViewport == jViewport2) {
            return;
        }
        if (jViewport2 != null) {
            jViewport2.removeChangeListener(this.viewportListener);
            this.scrollpane.remove(jViewport2);
        }
        if (jViewport != null) {
            Point point = jViewport.getViewPosition();
            point.x = Math.max(point.x, 0);
            point.y = Math.max(point.y, 0);
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "VIEWPORT");
            this.syncScrollPaneWithViewport();
            jViewport.addChangeListener(this.viewportListener);
        }
    }

    public JViewport getViewport() {
        return this.getSPLayout().getViewport();
    }

    public void setRowHeader(JViewport jViewport) {
        JViewport jViewport2 = this.getRowHeader();
        if (jViewport2 == jViewport) {
            return;
        }
        if (jViewport2 != null) {
            this.scrollpane.remove(jViewport2);
        }
        if (jViewport != null) {
            JViewport jViewport3 = this.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = jViewport3 != null ? jViewport3.getViewPosition().y : 0;
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "ROW_HEADER");
        }
    }

    public JViewport getRowHeader() {
        return this.getSPLayout().getRowHeader();
    }

    public void setColumnHeader(JViewport jViewport) {
        JViewport jViewport2 = this.getColumnHeader();
        if (jViewport2 == jViewport) {
            return;
        }
        if (jViewport2 != null) {
            this.scrollpane.remove(jViewport2);
        }
        if (jViewport != null) {
            JViewport jViewport3 = this.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = jViewport3 != null ? jViewport3.getViewPosition().x : 0;
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "COLUMN_HEADER");
        }
    }

    public JViewport getColumnHeader() {
        return this.getSPLayout().getColumnHeader();
    }

    public Component getCorner(String string) {
        return this.getSPLayout().getCorner(string);
    }

    public void setCorner(String string, Component component) {
        this.scrollpane.add(component, string);
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.getViewport();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.getHorizontalScrollBar();
        JViewport jViewport2 = this.getRowHeader();
        JViewport jViewport3 = this.getColumnHeader();
        if (jViewport != null) {
            int n;
            int n2;
            int n3;
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            Point point = jViewport.getViewPosition();
            if (jScrollBar != null) {
                n3 = dimension.height;
                n2 = dimension2.height;
                n = Math.max(0, Math.min(point.y, n2 - n3));
                jScrollBar.setValues(n, n3, 0, n2);
            }
            if (jScrollBar2 != null) {
                n3 = dimension.width;
                n2 = dimension2.width;
                n = Math.max(0, Math.min(point.x, n2 - n3));
                jScrollBar2.setValues(n, n3, 0, n2);
            }
            if (jViewport2 != null) {
                Point point2 = jViewport2.getViewPosition();
                point2.y = jViewport.getViewPosition().y;
                jViewport2.setViewPosition(point2);
            }
            if (jViewport3 != null) {
                Point point3 = jViewport3.getViewPosition();
                point3.x = jViewport.getViewPosition().x;
                jViewport3.setViewPosition(point3);
            }
        }
    }

    protected ChangeListener createViewportListener() {
        return new ViewportListener();
    }

    protected ChangeListener createHSBListener() {
        return new HSBListener();
    }

    protected ChangeListener createVSBListener() {
        return new VSBListener();
    }

    protected LayoutManager createLayoutManager() {
        return new BasicScrollPaneLayout();
    }

    protected JScrollBar createVerticalScrollBar() {
        return this.scrollpane.createVerticalScrollBar();
    }

    protected JScrollBar createHorizontalScrollBar() {
        return this.scrollpane.createHorizontalScrollBar();
    }

    protected class ViewportListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }

        ViewportListener() {
            BasicScrollPaneUI.this = BasicScrollPaneUI.this;
        }
    }

    protected class HSBListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                point.x = boundedRangeModel.getValue();
                jViewport.setViewPosition(point);
            }
        }

        HSBListener() {
            BasicScrollPaneUI.this = BasicScrollPaneUI.this;
        }
    }

    protected class VSBListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                point.y = boundedRangeModel.getValue();
                jViewport.setViewPosition(point);
            }
        }

        VSBListener() {
            BasicScrollPaneUI.this = BasicScrollPaneUI.this;
        }
    }

    protected class BasicScrollPaneLayout
    extends ScrollPaneLayout
    implements Serializable {
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }

        BasicScrollPaneLayout() {
            BasicScrollPaneUI.this = BasicScrollPaneUI.this;
        }
    }
}

