/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Rectangle;
import java.awt.Shape;

public abstract class CompositeView
extends View {
    private static View[] ONE = new View[1];
    private static View[] ZERO = new View[0];
    private View[] children = new View[1];
    private int nchildren = 0;
    private short left;
    private short right;
    private short top;
    private short bottom;

    public CompositeView(Element element) {
        super(element);
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            int n2 = 0;
            while (n2 < n) {
                viewArray[n2] = viewFactory.create(element.getElement(n2));
                ++n2;
            }
            this.replace(0, 0, viewArray);
        }
    }

    public void removeAll() {
        this.replace(0, this.nchildren, ZERO);
    }

    public void insert(int n, View view) {
        CompositeView.ONE[0] = view;
        this.replace(n, 0, ONE);
    }

    public void append(View view) {
        CompositeView.ONE[0] = view;
        this.replace(this.nchildren, 0, ONE);
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3;
        int n4 = n;
        while (n4 < n + n2) {
            this.children[n4].setParent(null);
            ++n4;
        }
        int n5 = viewArray.length - n2;
        int n6 = n + n2;
        int n7 = this.nchildren - n6;
        int n8 = n6 + n5;
        if (this.nchildren + n5 >= this.children.length) {
            n3 = Math.max(2 * this.children.length, this.nchildren + n5);
            View[] viewArray2 = new View[n3];
            System.arraycopy(this.children, 0, viewArray2, 0, n);
            System.arraycopy(viewArray, 0, viewArray2, n, viewArray.length);
            System.arraycopy(this.children, n6, viewArray2, n8, n7);
            this.children = viewArray2;
        } else {
            System.arraycopy(this.children, n6, this.children, n8, n7);
            System.arraycopy(viewArray, 0, this.children, n, viewArray.length);
        }
        this.nchildren += n5;
        n3 = 0;
        while (n3 < viewArray.length) {
            viewArray[n3].setParent(this);
            ++n3;
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    public int getViewCount() {
        return this.nchildren;
    }

    public View getView(int n) {
        return this.children[n];
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.childAllocation(n, rectangle);
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        Rectangle rectangle = this.getInsideAllocation(shape);
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            int n2 = view.getStartOffset();
            int n3 = view.getEndOffset();
            if (n >= n2 && n < n3) {
                return view.modelToView(n, rectangle);
            }
        }
        throw new BadLocationException("Position not represented by view", n);
    }

    public int viewToModel(float f, float f2, Shape shape) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        if (this.isBefore((int)f, (int)f2, rectangle)) {
            return this.getStartOffset();
        }
        if (this.isAfter((int)f, (int)f2, rectangle)) {
            return this.getEndOffset() - 1;
        }
        View view = this.getViewAtPoint((int)f, (int)f2, rectangle);
        if (view != null) {
            return view.viewToModel(f, f2, rectangle);
        }
        return -1;
    }

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        View view;
        int n2;
        Element element = this.getElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (element2 != null && n2 < this.getViewCount() && (view = this.getView(n2)).getElement() == element2) {
            if (rectangle != null) {
                this.childAllocation(n2, rectangle);
            }
            return view;
        }
        return null;
    }

    protected Rectangle getInsideAllocation(Shape shape) {
        if (shape != null) {
            Rectangle rectangle = new Rectangle(shape.getBounds());
            rectangle.x += this.left;
            rectangle.y += this.top;
            rectangle.width -= this.left + this.right;
            rectangle.height -= this.top + this.bottom;
            return rectangle;
        }
        return null;
    }

    protected final void setParagraphInsets(AttributeSet attributeSet) {
        this.top = (short)StyleConstants.getSpaceAbove(attributeSet);
        this.left = (short)StyleConstants.getLeftIndent(attributeSet);
        this.bottom = (short)StyleConstants.getSpaceBelow(attributeSet);
        this.right = (short)StyleConstants.getRightIndent(attributeSet);
    }

    protected final void setInsets(short s, short s2, short s3, short s4) {
        this.top = s;
        this.left = s2;
        this.right = s4;
        this.bottom = s3;
    }

    protected final short getLeftInset() {
        return this.left;
    }

    protected final short getRightInset() {
        return this.right;
    }

    protected final short getTopInset() {
        return this.top;
    }

    protected final short getBottomInset() {
        return this.bottom;
    }
}

