/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JEditorPane;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.Highlighter;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.SimpleAttributeSet;
import com.sun.java.swing.text.StyledDocument;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;

class ImageView
extends View
implements ImageObserver,
MouseListener,
MouseMotionListener,
Runnable {
    public static final String TOP = "top";
    public static final String TEXTTOP = "texttop";
    public static final String MIDDLE = "middle";
    public static final String ABSMIDDLE = "absmiddle";
    public static final String CENTER = "center";
    public static final String BOTTOM = "bottom";
    private static boolean sIsInc;
    private static int sIncRate;
    private Element fElement;
    private Image fImage;
    private int fHeight;
    private int fWidth;
    private Container fContainer;
    private Rectangle fBounds;
    private Component fComponent;
    private Point fGrowBase;
    private boolean fGrowProportionally;
    private static Icon sPendingImageIcon;
    private static Icon sMissingImageIcon;
    private static final String PENDING_IMAGE_SRC = "icons/image-delayed.gif";
    private static final String MISSING_IMAGE_SRC = "icons/image-failed.gif";
    private static final boolean DEBUG = false;
    static final String IMAGE_CACHE_PROPERTY = "imageCache";
    private static final int DEFAULT_WIDTH = 32;
    private static final int DEFAULT_HEIGHT = 32;
    private static final int DEFAULT_BORDER = 2;
    static /* synthetic */ Class class$com$sun$java$swing$text$html$ImageView;

    public ImageView(Element element) {
        super(element);
        this.initialize(element);
    }

    private void initialize(Element element) {
        boolean bl;
        boolean bl2;
        this.fElement = element;
        element.getAttributes();
        URL uRL = this.getSourceURL();
        if (uRL != null) {
            Dictionary dictionary = (Dictionary)this.getDocument().getProperty(IMAGE_CACHE_PROPERTY);
            this.fImage = dictionary != null ? (Image)dictionary.get(uRL) : Toolkit.getDefaultToolkit().getImage(uRL);
        }
        this.fHeight = this.getIntAttr("height", -1);
        boolean bl3 = bl2 = this.fHeight > 0;
        if (!bl2 && this.fImage != null) {
            this.fHeight = this.fImage.getHeight(this);
        }
        if (this.fHeight <= 0) {
            this.fHeight = 32;
        }
        this.fWidth = this.getIntAttr("width", -1);
        boolean bl4 = bl = this.fWidth > 0;
        if (!bl && this.fImage != null) {
            this.fWidth = this.fImage.getWidth(this);
        }
        if (this.fWidth <= 0) {
            this.fWidth = 32;
        }
        if (this.fImage != null) {
            if (bl && bl2) {
                Toolkit.getDefaultToolkit().prepareImage(this.fImage, this.fHeight, this.fWidth, this);
                return;
            }
            Toolkit.getDefaultToolkit().prepareImage(this.fImage, -1, -1, this);
        }
    }

    boolean isLink() {
        return this.fElement.getAttributes().isDefined("href");
    }

    int getBorder() {
        return this.getIntAttr("border", this.isLink() ? 2 : 0);
    }

    int getSpace(int n) {
        return this.getIntAttr(n == 0 ? "hspace" : "vspace", 0);
    }

    Color getBorderColor() {
        StyledDocument styledDocument = (StyledDocument)this.fElement.getDocument();
        AttributeSet attributeSet = this.fElement.getAttributes();
        return styledDocument.getForeground(attributeSet);
    }

    float getVerticalAlignment() {
        String string = (String)this.fElement.getAttributes().getAttribute("align");
        if (string != null) {
            if ((string = string.toLowerCase()).equals(TOP) || string.equals(TEXTTOP)) {
                return 0.0f;
            }
            if (string.equals(CENTER) || string.equals(MIDDLE) || string.equals(ABSMIDDLE)) {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    boolean hasPixels(ImageObserver imageObserver) {
        return this.fImage != null && this.fImage.getHeight(imageObserver) > 0 && this.fImage.getWidth(imageObserver) > 0;
    }

    private URL getSourceURL() {
        String string = (String)this.fElement.getAttributes().getAttribute("src");
        if (string == null) {
            return null;
        }
        URL uRL = (URL)this.fElement.getDocument().getProperty("stream");
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private int getIntAttr(String string, int n) {
        AttributeSet attributeSet = this.fElement.getAttributes();
        if (attributeSet.isDefined(string)) {
            int n2;
            String string2 = (String)attributeSet.getAttribute(string);
            if (string2 == null) {
                n2 = n;
            } else {
                try {
                    n2 = Math.max(0, Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                }
            }
            return n2;
        }
        return n;
    }

    public void setParent(View view) {
        super.setParent(view);
        Container container = this.fContainer = view != null ? this.getContainer() : null;
        if (view == null && this.fComponent != null) {
            this.fComponent.getParent().remove(this.fComponent);
            this.fComponent = null;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        boolean bl;
        super.changedUpdate(documentEvent, shape, viewFactory);
        float f = this.getVerticalAlignment();
        int n = this.fHeight;
        int n2 = this.fWidth;
        this.initialize(this.getElement());
        boolean bl2 = this.fHeight != n;
        boolean bl3 = bl = this.fWidth != n2;
        if (bl2 || bl || this.getVerticalAlignment() != f) {
            this.getParent().preferenceChanged(this, bl2, bl);
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        int n;
        Object object;
        Color color = graphics.getColor();
        this.fBounds = shape.getBounds();
        int n2 = this.getBorder();
        int n3 = this.fBounds.x + n2 + this.getSpace(0);
        int n4 = this.fBounds.y + n2 + this.getSpace(1);
        int n5 = this.fWidth;
        int n6 = this.fHeight;
        int n7 = this.getSelectionState();
        if (this.fComponent == null) {
            this.fComponent = new 1();
            this.fComponent.addMouseListener(this);
            this.fComponent.addMouseMotionListener(this);
            this.fComponent.setCursor(Cursor.getDefaultCursor());
            this.fContainer.add(this.fComponent);
        }
        this.fComponent.setBounds(n3, n4, n5, n6);
        if (!this.hasPixels(this)) {
            graphics.setColor(Color.lightGray);
            graphics.drawRect(n3, n4, n5 - 1, n6 - 1);
            graphics.setColor(color);
            this.loadIcons();
            Object object2 = object = this.fImage == null ? sMissingImageIcon : sPendingImageIcon;
            if (object != null) {
                object.paintIcon(this.getContainer(), graphics, n3, n4);
            }
        }
        if (this.fImage != null) {
            if (n7 > 0) {
                graphics.setXORMode(Color.white);
            }
            graphics.drawImage(this.fImage, n3, n4, n5, n6, this);
            if (n7 > 0) {
                graphics.setPaintMode();
            }
        }
        object = this.getBorderColor();
        if (n7 == 2) {
            n = 2 - n2;
            if (n > 0) {
                n3 += n;
                n4 += n;
                n5 -= n << 1;
                n6 -= n << 1;
                n2 = 2;
            }
            object = null;
            graphics.setColor(Color.black);
            graphics.fillRect(n3 + n5 - 5, n4 + n6 - 5, 5, 5);
        }
        if (n2 > 0) {
            if (object != null) {
                graphics.setColor((Color)object);
            }
            n = 1;
            while (n <= n2) {
                graphics.drawRect(n3 - n, n4 - n, n5 - 1 + n + n, n6 - 1 + n + n);
                ++n;
            }
            graphics.setColor(color);
        }
    }

    protected void repaint(long l) {
        if (this.fContainer != null && this.fBounds != null) {
            this.fContainer.repaint(l, this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height);
        }
    }

    protected int getSelectionState() {
        int n = this.fElement.getStartOffset();
        int n2 = this.fElement.getEndOffset();
        JTextComponent jTextComponent = (JTextComponent)this.fContainer;
        Highlighter highlighter = jTextComponent.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        int n3 = highlightArray.length - 1;
        while (n3 >= 0) {
            Highlighter.Highlight highlight = highlightArray[n3];
            int n4 = highlight.getStartOffset();
            int n5 = highlight.getEndOffset();
            if (n4 <= n && n5 >= n2) {
                if (n4 == n && n5 == n2 && this.isEditable()) {
                    return 2;
                }
                return 1;
            }
            --n3;
        }
        return 0;
    }

    protected boolean isEditable() {
        return this.fContainer instanceof JEditorPane && ((JEditorPane)this.fContainer).isEditable();
    }

    protected Color getHighlightColor() {
        JTextComponent jTextComponent = (JTextComponent)this.fContainer;
        return jTextComponent.getSelectionColor();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.fImage == null) {
            return false;
        }
        if ((n & 0xC0) != 0) {
            this.fImage = null;
            this.repaint(0L);
            return false;
        }
        boolean bl = false;
        if ((n & 2) != 0 && !this.getElement().getAttributes().isDefined("height")) {
            this.fHeight = n5;
            bl = true;
        }
        if ((n & 1) != 0 && !this.getElement().getAttributes().isDefined("width")) {
            this.fWidth = n4;
            bl = true;
        }
        if (bl) {
            SwingUtilities.invokeLater(this);
            return true;
        }
        if ((n & 0x30) != 0) {
            this.repaint(0L);
        } else if ((n & 8) != 0 && sIsInc) {
            this.repaint(sIncRate);
        }
        return true;
    }

    public void run() {
        this.preferenceChanged(this, true, true);
    }

    public float getPreferredSpan(int n) {
        int n2 = 2 * (this.getBorder() + this.getSpace(n));
        switch (n) {
            case 0: {
                return this.fWidth + n2;
            }
            case 1: {
                return this.fHeight + n2;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                return this.getVerticalAlignment();
            }
        }
        return super.getAlignment(n);
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n < n3) {
            Rectangle rectangle = new Rectangle(shape.getBounds());
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape) {
        return this.getStartOffset();
    }

    public void setSize(float f, float f2) {
    }

    protected void resize(int n, int n2) {
        if (n == this.fWidth && n2 == this.fHeight) {
            return;
        }
        this.fWidth = n;
        this.fHeight = n2;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute("width", Integer.toString(n));
        simpleAttributeSet.addAttribute("height", Integer.toString(n2));
        ((StyledDocument)this.getDocument()).setCharacterAttributes(this.fElement.getStartOffset(), this.fElement.getEndOffset(), simpleAttributeSet, false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Dimension dimension = this.fComponent.getSize();
        if (mouseEvent.getX() >= dimension.width - 7 && mouseEvent.getY() >= dimension.height - 7 && this.getSelectionState() == 2) {
            Point point = this.fComponent.getLocationOnScreen();
            this.fGrowBase = new Point(point.x + mouseEvent.getX() - this.fWidth, point.y + mouseEvent.getY() - this.fHeight);
            this.fGrowProportionally = mouseEvent.isShiftDown();
            return;
        }
        this.fGrowBase = null;
        JTextComponent jTextComponent = (JTextComponent)this.fContainer;
        int n = this.fElement.getStartOffset();
        int n2 = this.fElement.getEndOffset();
        int n3 = jTextComponent.getCaret().getMark();
        int n4 = jTextComponent.getCaret().getDot();
        if (mouseEvent.isShiftDown()) {
            if (n3 <= n) {
                jTextComponent.moveCaretPosition(n2);
                return;
            }
            jTextComponent.moveCaretPosition(n);
            return;
        }
        if (n3 != n) {
            jTextComponent.setCaretPosition(n);
        }
        if (n4 != n2) {
            jTextComponent.moveCaretPosition(n2);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fGrowBase != null) {
            Point point = this.fComponent.getLocationOnScreen();
            int n = Math.max(2, point.x + mouseEvent.getX() - this.fGrowBase.x);
            int n2 = Math.max(2, point.y + mouseEvent.getY() - this.fGrowBase.y);
            if (mouseEvent.isShiftDown() && this.fImage != null) {
                int n3 = this.fImage.getWidth(this);
                int n4 = this.fImage.getHeight(this);
                if (n3 > 0 && n4 > 0) {
                    float f = (float)n4 / (float)n3;
                    float f2 = (float)n2 / f;
                    float f3 = (float)n * f;
                    if (f2 > (float)n) {
                        n = (int)f2;
                    } else {
                        n2 = (int)f3;
                    }
                }
            }
            this.resize(n, n2);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.fGrowBase = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.getClickCount();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private Icon makeIcon(String string) throws IOException {
        int n;
        InputStream inputStream = (class$com$sun$java$swing$text$html$ImageView != null ? class$com$sun$java$swing$text$html$ImageView : (class$com$sun$java$swing$text$html$ImageView = ImageView.class$("com.sun.java.swing.text.html.ImageView"))).getResourceAsStream(string);
        if (inputStream == null) {
            System.err.println(String.valueOf((class$com$sun$java$swing$text$html$ImageView != null ? class$com$sun$java$swing$text$html$ImageView : (class$com$sun$java$swing$text$html$ImageView = ImageView.class$("com.sun.java.swing.text.html.ImageView"))).getName()) + "/" + string + " not found.");
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        ((FilterInputStream)bufferedInputStream).close();
        byteArrayOutputStream.flush();
        byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length == 0) {
            System.err.println("warning: " + string + " is zero-length");
            return null;
        }
        return new ImageIcon(byArray);
    }

    private void loadIcons() {
        try {
            if (sPendingImageIcon == null) {
                sPendingImageIcon = this.makeIcon(PENDING_IMAGE_SRC);
            }
            if (sMissingImageIcon == null) {
                sMissingImageIcon = this.makeIcon(MISSING_IMAGE_SRC);
                return;
            }
        }
        catch (Exception exception) {
            System.err.println("ImageView: Couldn't load image icons");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("awt.image.incrementaldraw");
        sIsInc = string == null || string.equals("true");
        string = System.getProperty("awt.image.redrawrate");
        sIncRate = string != null ? Integer.parseInt(string) : 100;
    }

    private final class 1
    extends Component {
        /* synthetic */ 1() {
        }
    }
}

