/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import logformat.clog2.Const;

public class Preamble {
    private static final int BYTESIZE = 1024;
    private static final int VERSIONSIZE = 12;
    private String version;
    private String is_big_endian_title;
    private boolean is_big_endian;
    private String block_size_title;
    private int block_size;
    private String num_blocks_title;
    private int num_blocks;

    public boolean readFromDataStream(DataInputStream dataInputStream) {
        byte[] byArray = new byte[1024];
        try {
            dataInputStream.readFully(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray), "\u0000");
        try {
            this.version = stringTokenizer.nextToken().trim();
            this.is_big_endian_title = stringTokenizer.nextToken().trim();
            String string = stringTokenizer.nextToken().trim();
            this.is_big_endian = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
            this.block_size_title = stringTokenizer.nextToken().trim();
            this.block_size = Integer.parseInt(stringTokenizer.nextToken().trim());
            this.num_blocks_title = stringTokenizer.nextToken().trim();
            this.num_blocks = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return false;
        }
        return true;
    }

    public String getVersionString() {
        return this.version;
    }

    public boolean isVersionMatched() {
        return this.version.equalsIgnoreCase("CLOG-02.20");
    }

    public boolean isVersionCompatible() {
        boolean bl = false;
        for (int i = 0; i < Const.COMPAT_VERSIONS.length && !bl; ++i) {
            String string = Const.COMPAT_VERSIONS[i];
            bl = this.version.equalsIgnoreCase(string);
        }
        return bl;
    }

    public boolean isBigEndian() {
        return this.is_big_endian;
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public String toString() {
        return this.version + "\n" + this.is_big_endian_title + this.is_big_endian + "\n" + this.block_size_title + this.block_size + "\n" + this.num_blocks_title + this.num_blocks + "\n";
    }
}

