/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import viewer.common.Const;

public class ScaledSlider
extends JSlider {
    private static final long serialVersionUID = 4700L;
    private static final Font FONT = Const.FONT;
    private static final int MODEL_MIN = 0;
    private static final int MODEL_MAX = 1000000000;
    private double label_min;
    private double label_max;
    private double ratio_label2model;
    private Font label_font;
    private DecimalFormat label_fmt;

    public ScaledSlider(int n) {
        super(n, 0, 1000000000, 0);
        super.setBackground(Color.white);
        super.setPaintTrack(true);
        super.setPaintLabels(true);
        super.setPaintTicks(true);
        super.setFont(FONT);
        super.setBorder(BorderFactory.createLoweredBevelBorder());
        this.label_min = 0.0;
        this.label_max = 100.0;
        this.label_font = FONT;
        this.setLabelFormat("###0.0##");
    }

    public void setLabelFormat(String string) {
        if (string != null) {
            this.label_fmt = (DecimalFormat)NumberFormat.getInstance();
            this.label_fmt.applyPattern(string);
        }
    }

    private double getModel2LabelValue(int n) {
        return this.ratio_label2model * (double)(n - 0) + this.label_min;
    }

    private int getLabel2ModelValue(double d) {
        double d2 = (d - this.label_min) / this.ratio_label2model + 0.0;
        return (int)Math.round(d2);
    }

    private int getLabel2ModelInterval(double d) {
        return (int)Math.round(d / this.ratio_label2model);
    }

    private static double getMajorTickIntervalLabel(double d) {
        if (d < 11.0) {
            return 1.0;
        }
        if (d < 22.0) {
            return 2.0;
        }
        if (d < 55.0) {
            return 5.0;
        }
        if (d < 110.0) {
            return 10.0;
        }
        if (d < 220.0) {
            return 20.0;
        }
        if (d < 440.0) {
            return 40.0;
        }
        if (d < 550.0) {
            return 50.0;
        }
        return 100.0;
    }

    public void setLabelFont(Font font) {
        Dictionary dictionary;
        this.label_font = font;
        if (super.getPaintLabels() && (dictionary = super.getLabelTable()) != null) {
            Enumeration enumeration = super.getLabelTable().elements();
            while (enumeration.hasMoreElements()) {
                JComponent jComponent = (JComponent)enumeration.nextElement();
                jComponent.setFont(this.label_font);
            }
        }
    }

    private void setDefaultLabelTable() {
        if (this.label_fmt == null || !super.getPaintLabels()) {
            return;
        }
        double d = ScaledSlider.getMajorTickIntervalLabel(this.label_max);
        int n = this.getLabel2ModelInterval(d);
        super.setMajorTickSpacing(n);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < 1000000000; i += n) {
            double d2 = this.getModel2LabelValue(i);
            JLabel jLabel = new JLabel(this.label_fmt.format(d2));
            jLabel.setFont(this.label_font);
            hashtable.put(new Integer(i), jLabel);
        }
        super.setLabelTable(hashtable);
    }

    public void setMaxLabel(double d) {
        this.label_max = d;
        this.ratio_label2model = (this.label_max - this.label_min) / 1.0E9;
        this.setDefaultLabelTable();
    }

    public void setMaxLabel(int n) {
        this.setMaxLabel((double)n);
    }

    public double getMaxLabel() {
        return this.label_max;
    }

    public void setMinLabel(double d) {
        this.label_min = d;
        this.ratio_label2model = (this.label_max - this.label_min) / 1.0E9;
        this.setDefaultLabelTable();
    }

    public void setMinLabel(int n) {
        this.setMinLabel((double)n);
    }

    public double getMinLabel() {
        return this.label_min;
    }

    public void setValLabel(double d) {
        double d2 = d;
        if (d2 > this.label_max) {
            System.err.println("label_value(" + d2 + ") > label_max(" + this.label_max + ")");
            this.setMaxLabel(d2);
        } else if (d2 < this.label_min) {
            System.err.println("label_value(" + d2 + ") < label_min(" + this.label_min + ")");
            this.setMinLabel(d2);
        }
        int n = this.getLabel2ModelValue(d2);
        if (n > 1000000000) {
            System.err.println("model_value(" + n + ") > MODEL_MAX(" + 1000000000 + ")");
        } else if (n < 0) {
            System.err.println("model_value(" + n + ") < MODEL_MIN(" + 0 + ")");
        }
        super.setValue(n);
    }

    public double getValLabel() {
        return this.getModel2LabelValue(super.getValue());
    }

    public void setValLabelFully(double d) {
        this.setValLabel(d);
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }
}

