/*
 * The key associated with a record may be a sequence of codes,
 * a (pointer to a) floating point number, a numeric string struct,
 * or a hybrid structure.
 */	 

struct HybridList {
  unsigned char cnt;		/* Number of subparts - high bit indicates first bit is numeric */
  long int *ilist;		/* Numeric portions */
  wchar_t **tlist;		/* Textual portions */
};

union key{
  wchar_t *t;
#ifdef HAVE_LONGDOUBLE
  long double *n;
#else
  double *n;
#endif
  struct {
    int   cnt;
    char *txt;
    char sign;
  } N;
  struct HybridList *H;
};

/*
 * A record contains the text, and a list of the keys extracted
 * from the record.
 */

struct record{
  size_t length;		/* Length of text in characters */
  UTF8 *text;			/* The text itself */
  off_t fpos;			/* File offset for semi-external sort */
  union key *klistptr;		/* List of keys */
};
