/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: datatype.h,v 3.4 2001/10/29 16:35:50 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASASKI_DATATYPE_H
#define	_MURASASKI_DATATYPE_H

/* USB configuration */
typedef struct {
	unsigned int	vendor;
	unsigned int	product;
	unsigned int	device_lo,device_hi;
} MU_usb_product_t;

typedef struct {
	unsigned int	class;
	unsigned int	subclass;
	unsigned int	protocol;
} MU_usb_type_t;

typedef struct {
	char *name;
	unsigned int match_flags;
	MU_usb_product_t product;
	MU_usb_type_t	device;
	MU_usb_type_t	interface;
} MU_usb_config_t;

/* PCI configuration */
typedef struct {
	unsigned int vendor;
	unsigned int device;
} MU_pci_id_t;

typedef struct {
	char *name;
	unsigned int class;
	unsigned int class_mask;
	MU_pci_id_t id;
	MU_pci_id_t sub_id;
	char *slot;
} MU_pci_config_t;

/* NET configuration */
typedef struct {
	char *name;
} MU_net_config_t;

/* IEEE1394 configuration */
typedef struct {
	char *name;
	unsigned int match_flags;
	unsigned int vendor;
	unsigned int model;
/* Now, 'guid' is not available 
	long long unsigned guid;
*/
	unsigned int specifier;
	unsigned int version;
} MU_ieee1394_config_t;

struct mu_op {
	char *command;
	char *mappath;
	char *default_mapname;
	void *config;
	void (*get_info)(void);
	int (*run)(struct mu_op *,int);
	void (*end)(struct mu_op *);
};

#endif	/* _MURASASKI_DATATYPE_H */

