//driver_ao.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "muroard.h"
#include <ao/ao.h>

ao_device        * driver_ao_device = NULL;

#define DRIVER_HAVE_INIT
#define DRIVER_HAVE_FREE
#define DRIVER_HAVE_WRITE

int driver_init(char * dev) {
 ao_sample_format  format;
  int              driver;

 ao_initialize();

 driver = ao_default_driver_id();

 format.bits        = 16;
 format.channels    = g_sa_channels;
 format.rate        = g_sa_rate;

 format.byte_format = AO_FMT_NATIVE;

 driver_ao_device = ao_open_live(driver, &format, NULL /* no options */);

 if ( driver_ao_device == NULL )
  return -1;

 return 0;
}

int driver_free(void) {
 if ( driver_ao_device != NULL )
  ao_close(driver_ao_device);

 ao_shutdown();
 return 0;
}

int driver_write(int16_t * data) {
 if ( ao_play(driver_ao_device, (char*)data, g_abuffer_size) == 0 )
  return -1;
 return 0;
}

//ll
