//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: canvas.h,v 1.2 2001/11/20 15:19:34 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __CANVAS_H__
#define __CANVAS_H__

#include "citem.h"
#include "view.h"
#include "tools.h"

//---------------------------------------------------------
//   Canvas
//---------------------------------------------------------

class Canvas : public View {
      Q_OBJECT

   protected:
      enum DragMode { DRAG_OFF, DRAG_NEW, DRAG_MOVE_START, DRAG_MOVE,
            DRAG_DELETE, DRAG_COPY_START, DRAG_COPY,
            DRAG_RESIZE, DRAG_LASSO_START, DRAG_LASSO,
            DRAGX_MOVE, DRAGX_COPY, DRAGY_MOVE, DRAGY_COPY
            };

      CItemList items;
      CItemList moving;
      CItem* curItem;
      Part* curPart;
      int curPartId;

      DragMode drag;
      QRect lasso;
      QPoint start;
      Tool _tool;
      int pos[3];
      int yOffset;
      int keyState;
      QPopupMenu* itemPopupMenu;

      void setCursor();
      virtual void viewKeyPressEvent(QKeyEvent* event);
      virtual void viewMousePressEvent(QMouseEvent* event);
      virtual void viewMouseMoveEvent(QMouseEvent*);
      virtual void viewMouseReleaseEvent(QMouseEvent*);
      virtual void draw(QPainter&, const QRect&);

      virtual void mousePress(QMouseEvent*) {}
      virtual void keyPress(QKeyEvent*);
      virtual void mouseMove(const QPoint&) = 0;
      virtual void mouseRelease(const QPoint&) {}
      virtual void drawCanvas(QPainter&, const QRect&) = 0;
      virtual void drawItem(QPainter&, const CItem*, const QRect&) const = 0;
      virtual void updateSelection() = 0;
      virtual QPoint raster(const QPoint&) const = 0;
      virtual int y2pitch(int) const = 0; //CDW
      virtual int pitch2y(int) const = 0; //CDW

      virtual bool moveItem(CItem*, const QPoint&, bool) = 0;
      virtual CItem* newItem(const QPoint&, int state) = 0;
      virtual void resizeItem(CItem*, bool noSnap=false) = 0;
      virtual void newItem(CItem*, bool noSnap=false) = 0;
      virtual bool deleteItem(CItem*) = 0;
      virtual void startUndo(bool) = 0;
      virtual void endUndo(bool) = 0;

      virtual QPopupMenu* genItemPopup(CItem*) { return 0; }
      virtual void itemPopup(CItem*, int, const QPoint&) {}

      virtual void startDrag(CItem*, bool) {}

      // selection
      virtual void deselectAll();
      virtual void selectItem(CItem* e, bool);

      virtual void deleteItem(const QPoint&);

      // moving
      void startMoving(const QPoint&, bool copyflag);
      void moveItems(const QPoint&, int dir);
      void endMoveItems(const QPoint&, bool copyflag, int dir);

      virtual void selectLasso(bool toggle);

      virtual void itemPressed(const CItem*) {}
      virtual void itemReleased(const CItem*, const QPoint&) {}
      virtual void itemMoved(const CItem*, const QPoint&) {}
      virtual void curPartChanged() {}

   public slots:
      void setTool(int t);
      void setPos(int, int, bool adjustScrollbar);

   signals:
      void followEvent(int);

   public:
      Canvas(QWidget* parent, int sx, int sy, const char* name = 0);
      bool isSingleSelection();
      int selectionSize();
      Tool tool() const { return _tool; }
      Part* part() const { return curPart; }
      };
#endif

