//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audiodev.h,v 1.1.1.1 2003/10/29 10:06:13 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIODEV_H__
#define __AUDIODEV_H__

#include <qstring.h>
#include <list>

//---------------------------------------------------------
//   AudioDevice
//---------------------------------------------------------

class AudioDevice {
   protected:
      QString _inputPort;
      QString _outputPort;
      QString _state;

   public:
      AudioDevice() {}
      virtual ~AudioDevice() {}

      QString state() const { return _state; }
      void setState(const QString& s)  { _state = s; }
      virtual void read(int, unsigned long, float**) = 0;
      virtual void write(int, unsigned long, float**) {}
      virtual bool getWriteBuffer(int, unsigned long, float**) { return false; }

      virtual void start() = 0;
      virtual void stop () = 0;
      virtual int curPlayPos() const = 0;
      virtual std::list<QString> outputPorts() = 0;
      virtual std::list<QString> inputPorts() = 0;
      virtual QString inputPort() const { return _inputPort; }
      virtual QString outputPort() const { return _outputPort; }
      virtual void setInputPort(const QString&) = 0;
      virtual void setOutputPort(const QString&) = 0;
      virtual void activate(bool) = 0;
      };

#endif

