/***************************************************************************
                          gnusock.cpp  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "controller.h"

#include "preferences.h"
#include "gnuhash.h"
#include "gnudirector.h"
#include "gnudownload.h"
#include "gnuupload.h"
#include "gnunode.h"
#include "gnusock.h"

/////////////////////////////////////////////////////////////////////////////
// MGnuSock

MGnuSock::MGnuSock(MGnuDirector* pComm)
{	
	m_pDirector  = pComm;
	m_pPrefs = m_pDirector->GetPrefs();

	m_nSecsAlive = 0;
	m_bDestroy   = false;
	//printf("sock created\n");
}

MGnuSock::~MGnuSock()
{
	//printf("sock destroed\n");
}

/////////////////////////////////////////////////////////////////////////////
// MGnuSock member functions

void MGnuSock::OnClose(int nErrorCode)
{
	//printf("MGnuSock::OnClose; errno=%d\n", errno);
	ForceDisconnect();
}

void MGnuSock::OnReceive(int nErrorCode) 
{
	//printf("sock on receive\n");
	DWORD dwBuffLength = Receive(m_pBuff, 32768);

	// The socket will be dead by the end of the function
	// Tag for cleanup
	m_bDestroy = true;

	switch (dwBuffLength)
	{
	case 0:
		//printf("MGnuSock::OnReceive: zero-size; errno=%d\n", errno);
		ForceDisconnect();
		return;
		break;
	case SOCKET_ERROR:
		ForceDisconnect();
		return;
		break;
	}

	m_pBuff[dwBuffLength] = 0;
	CString Handshake((char*)m_pBuff);

	// Get Connected's info
	CString Host;
	UINT    nPort;
	GetPeerName(Host, nPort);

	// New Connection
	if(Handshake.find("CONNECT/0.") != -1)
	{
		// Check for duplicate connections
		if(m_pDirector->FindNode(Host, 0) != NULL)
		{
			ForceDisconnect();
			return;
		}

		// Check for screened connects
		if( !m_pDirector->CheckIP( StrtoIP(Host) ))
		{
			ForceDisconnect();
			return;
		}

		// Create a new node connection
		MGnuNode* NodeSock		= new MGnuNode(m_pDirector, Host, 0, true, false);
		NodeSock->m_nStatus		= SOCK_NEGOTIATING;

		// Convert this socket to a Node Socket
		SOCKET FreeSock = Detach();
		NodeSock->Attach(FreeSock, FD_READ | FD_CLOSE);

		m_pDirector->AddNode(NodeSock);
		
		m_pDirector->NodeMessage(SOCK_UPDATE, 0);

		if(!NodeSock->ParseHandshake(Handshake, m_pBuff, dwBuffLength))
			NodeSock->ForceDisconnect();

		ForceDisconnect();
		return;
	}

	// New Upload
	else if(Handshake.find("GET /get/") == 0)
	{	
		// check if we have a complete header
		int npos = Handshake.find("\r\n\r\n");
		/*if (npos<0)
		{
			printf("incomplete upload request\n");
			ForceDisconnect();
			return;
		}*/
		// Create a new node connection
		MGnuUpload* UploadSock = new MGnuUpload(m_pDirector);
		//
		m_pDirector->AddUpload(UploadSock);
		//
		UploadSock->m_mutex.lock();
		// Set Variables
		UploadSock->m_ipHost      = StrtoIP(Host);
		UploadSock->m_nPort       = 0;
		UploadSock->m_sHandshake += Handshake;
		UploadSock->m_nStatus     = TRANSFER_CONNECTED;

		// Convert this socket to a Node Socket
		SOCKET FreeSock = Detach();
		UploadSock->Attach(FreeSock, FD_READ | FD_CLOSE);
			
		//
		UploadSock->UploadFile(Handshake, false);
		//
		UploadSock->m_mutex.unlock();
		//
		m_pDirector->TransferMessage(UPLOAD_UPDATE, (WPARAM) UploadSock);

		ForceDisconnect();
		return;
	}

	// Server Requesting to Push a file to us
	else if(Handshake.find("GIV ") == 0)
	{
		DWORD	Index;
		CString FileName;

		// TODO: Get GUID and check also
		sscanf( Handshake.c_str(), "GIV %ld:*/*\r\n", &Index);

		int Front = Handshake.find("/") + 1,
			End   = Handshake.find("\n\n");
		FileName  = Handshake.substr(Front, End - Front);
		MakeLower(FileName);

		// Find the download that requested the push
		MGnuDownload *p = m_pDirector->LookUpDownload(FileName, Index);
		if (p)
		{
			p->m_mutex.lock();
			// check if we still waiting for a push
			if (p->m_nStatus == TRANSFER_PUSH ||
			    p->m_nStatus == TRANSFER_CONNECTING ||
			    p->m_nStatus == TRANSFER_COOLDOWN ||
			    p->m_nStatus == TRANSFER_CLOSED )
			{
				// lets find the index of the result
				int nPush;
				for(nPush = 0; nPush < p->m_Queue.size(); nPush++)
					if(p->m_Queue[nPush].FileIndex == Index && p->m_Queue[nPush].NameLower == FileName)
						break;
				if (nPush < p->m_Queue.size()) // just for any case
				{
					// we failed to connect since we requested this push, so roll back to it and make use of it
					if( m_pDirector->GetPrefs()->m_nMaxPerHostDownloads > 0 && m_pDirector->CountDownloads(StrtoIP(Host), p) > m_pDirector->GetPrefs()->m_nMaxPerHostDownloads )
					{
						ForceDisconnect();
						// check if we were waiting for the same push
						if (p->m_nQueuePos == nPush)
						{
							//ASSERT(p->m_mutex.locked());
							p->ForceDisconnect(REASON_HOST_OCCUPIED);
						}
						else
							p->m_Queue[nPush].ErrorCode = REASON_HOST_OCCUPIED;
						p->m_Queue[nPush].bServerIsUp = true;
						p->m_Queue[nPush].nPushTimeouts = 0; // we had a reply
						p->m_mutex.unlock();
						return;
					}
					// we will go with this connect
					if (p->m_nQueuePos != nPush)
					{
						//ASSERT(p->m_mutex.locked());
						p->ForceDisconnect(REASON_NO_RESPONSE);
						p->m_nQueuePos = nPush;
					}
					SOCKET FreeSock = Detach();
					p->Close();
					p->Attach(FreeSock, FD_READ | FD_CLOSE);
			
					p->CheckFile(); // it will send the request upon successful
					// opening of the file
					p->StatusUpdate(TRANSFER_CONNECTED);
					//p->SendRequest();
				}
			}
			p->m_mutex.unlock();
			ForceDisconnect();
		}
	}
	
	// HTML request
	else if(Handshake.find("GET /") == 0)
	{
		CString Http200 =  "HTTP 200\r\n";
				Http200 += "Server: Mutella\r\n";
				Http200 += "Content-type:text/html\r\n\r\n";
				Http200 += "<HTML>\r\n";
				Http200 += "<HEAD><TITLE>Gnutella Network</TITLE></HEAD>\r\n";
				Http200 += "<BODY>\r\n";
				Http200 += "<H1>Gnutella</H1>\r\n";
				Http200 += "This is not a web server, it's a Gnutella-network node.\r\n";
				Http200 += "<HR NOSHADE SIZE=1>\r\n";
				Http200 += "Powered by <I><B><A HREF=\"http://mutella.sourceforge.net\">Mutella</A></B></I>.\r\n";
				Http200 += "</BODY></HTML>\r\n\r\n";
		
		Send(Http200.c_str(), Http200.length());
		Close();
	}

	MAsyncSocket::OnReceive(nErrorCode);
}

void MGnuSock::ForceDisconnect()
{
	if(m_hSocket != INVALID_SOCKET)
	{
		AsyncSelect(FD_CLOSE);
		ShutDown(2);
	}

	Close();
}

// Called every once a second
void MGnuSock::Timer()
{
	m_nSecsAlive++;
}