
check_details()
{
  server=$1
  file_name_prepare=$2
  file_name_connection=$3
  file_name_profile=$4
  file_name_out=$5
  file_name_clean=$6
  test_prompt=$7

  load_members $server

  if [ "x$this_enabled" = "x0" ]; then
    print_test_skipped $test_prompt
  else
    name_draft_file="r/${file_name_out}.backup.draft.sql"
    name_connection="t/${file_name_connection}.test.connection.xml"
    name_prepared_connection="t/${file_name_connection}.test.connection.prepared.xml"
    name_backup_profile="t/${file_name_profile}.test.backup_profile.xml"

    name_progress_log="r/${file_name_profile}.progress_log"
    name_progress_log_etalon="r/${file_name_profile}.progress_log.etalon"
    name_progress_log_diff="r/${file_name_profile}.progress_log.diff"

    name_output="r/${file_name_profile}.output"
    name_output_etalon="r/${file_name_profile}.output.etalon"
    name_output_diff="r/${file_name_profile}.output.diff"

    name_backup="r/${file_name_out}.backup.sql"
    name_backup_etalon="r/${file_name_out}.backup.etalon.sql"
    name_backup_diff="r/${file_name_out}.backup.diff"

    server_prepare_connection_file $server $name_connection $name_prepared_connection
    server_execute_script $server "t/${file_name_prepare}.prepare.sql"
    ./test_make_backup $name_prepared_connection $name_backup_profile $name_draft_file 5 $name_progress_log x > $name_output 2>&1
    server_execute_script $server "t/${file_name_clean}.clean.sql"
    rm $name_prepared_connection

    discard_volatile_results $name_draft_file $name_backup
  
    compare_results $name_progress_log_etalon $name_progress_log $name_progress_log_diff
    fc_result1=$?
    compare_results $name_output_etalon       $name_output       $name_output_diff
    fc_result2=$?
    compare_results $name_backup_etalon       $name_backup       $name_backup_diff
    fc_result3=$?
    fc_result=`expr $fc_result1 + $fc_result2 + $fc_result3`

    print_test_res "$test_prompt" $fc_result
  fi
}

check()
{
  server=$1
  file_name=$2
  test_prompt=$3

  check_details $server $file_name $file_name $file_name $file_name $file_name "$test_prompt"
}

print_title "test make backup"

server_safe_start server_40
check server_40 mysql_40_simple "simple backup of mysql-4.0"
check_details server_40 mysql_40_simple mysql_40_simple mysql_40_ansi mysql_40_ansi mysql_40_simple "simple backup of mysql-4.0 with ansi quotas"
server_safe_stop server_40

server_safe_start server_41
check server_41 mysql_41_simple "simple backup of mysql-4.1"
check_details server_41 mysql_41_simple mysql_41_simple mysql_41_ansi mysql_41_ansi mysql_41_simple "simple backup of mysql-4.1 with ansi quotas"
server_safe_stop server_41

print_footer
